/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.print.builder;

import br.com.sankhya.sps.annotation.type.loader.AutoSense;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.PrintServiceUtil;
import br.com.sankhya.sps.util.print.DocumentPrinter;
import br.com.sankhya.sps.util.print.DocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.listener.PrintJobStatusListener;
import br.com.sankhya.sps.util.print.loader.DocumentLoader;
import br.com.sankhya.sps.util.print.printer.AutoSenseDocumentPrinter;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.print.DocFlavor;
import javax.print.PrintService;

public class AutoSenseDocumentPrinterBuilder
implements DocumentPrinterBuilder {
    private Provider<JobService> jobServiceProvider;
    private DocumentLoader<InputStream> documentLoader;
    private PrintServiceUtil printServiceUtil;
    private JobUtil jobUtil;

    @Inject
    AutoSenseDocumentPrinterBuilder(Provider<JobService> jobServiceProvider, @AutoSense DocumentLoader<InputStream> documentLoader, PrintServiceUtil printServiceUtil, JobUtil jobUtil) {
        this.jobServiceProvider = jobServiceProvider;
        this.documentLoader = documentLoader;
        this.printServiceUtil = printServiceUtil;
        this.jobUtil = jobUtil;
    }

    @Override
    public DocumentPrinter create(Job job) {
        try {
            InputStream inputStream = this.documentLoader.load(job);
            JobService jobService = (JobService)this.jobServiceProvider.get();
            PrintJobStatusListener listener = new PrintJobStatusListener(job, jobService);
            PrintService printService = this.printServiceUtil.getPrintService(job);
            DocFlavor docFlavor = this.jobUtil.getDocFlavor(job);
            return new AutoSenseDocumentPrinter(inputStream, job, listener, printService, docFlavor);
        }
        catch (Exception e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR);
        }
    }
}

