/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.conversion.jdom.element;

import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.conversion.exception.ConversionErrorCode;
import br.com.sankhya.sps.conversion.exception.ConversionException;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.util.XmlUtil;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class ValidationResultToElementConverter
implements Converter<ValidationResult, Element> {
    public Element convert(ValidationResult validationResult) {
        try {
            Element root = new Element("validationResult");
            if (validationResult != null) {
                root.setAttribute("valid", String.valueOf(validationResult.isValid()));
                if (!validationResult.isValid()) {
                    root.setAttribute("message", "Ocorreram erros de valida\u00e7\u00e3o");
                } else {
                    root.setAttribute("message", "Valida\u00e7\u00e3o efetuada com sucesso");
                }
                Element validationErrorElement = null;
                List<ValidationError> validationErrors = validationResult.getValidationErrors();
                for (ValidationError v : validationErrors) {
                    validationErrorElement = new Element("validationError");
                    XmlUtil.addSimpleElement(validationErrorElement, "errorContext", v.getErrorContext());
                    XmlUtil.addSimpleElement(validationErrorElement, "errorMessage", v.getErrorMessage());
                    XmlUtil.addSimpleElement(validationErrorElement, "validationType", v.getValidationType());
                    root.addContent((Content)validationErrorElement);
                }
            }
            return root;
        }
        catch (Exception e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_VALIDATION_RESULT, (Throwable)e);
        }
    }
}

