/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.conversion.jdom.element;

import br.com.sankhya.sps.business.exception.BusinessValidationException;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.conversion.exception.ConversionErrorCode;
import br.com.sankhya.sps.conversion.exception.ConversionException;
import br.com.sankhya.sps.conversion.jdom.element.AbstractBaseExceptionToElementConverter;
import br.com.sankhya.sps.exception.BaseException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.jdom.Content;
import org.jdom.Element;

public class BusinessValidationExceptionToElementConverter
extends AbstractBaseExceptionToElementConverter<BusinessValidationException> {
    private ConversionUtil conversionUtil;

    public BusinessValidationExceptionToElementConverter(ConversionUtil conversionUtil) {
        this.conversionUtil = conversionUtil;
    }

    public Element convert(BusinessValidationException businessValidationException) {
        Element root = null;
        try {
            root = super.convert((BaseException)businessValidationException);
            Element constraintViolationsElement = new Element("constraintViolations");
            Element validationResultElement = null;
            Set<ConstraintViolation<?>> constraintViolations = businessValidationException.getConstraintViolations();
            for (ConstraintViolation<?> constraintViolation : constraintViolations) {
                validationResultElement = (Element)this.conversionUtil.convert(constraintViolation, Element.class);
                constraintViolationsElement.addContent((Content)validationResultElement);
            }
            root.addContent((Content)constraintViolationsElement);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwConversionException(e);
        }
        return root;
    }

    protected void throwConversionException(Exception e) {
        throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_BUSINESS_VALIDATION_EXCEPTION, (Throwable)e);
    }
}

