/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util.conversion.jasper;

import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.conversion.exception.ConversionErrorCode;
import br.com.sankhya.sps.conversion.exception.ConversionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class JasperPrintToExportedByteArrayConverter
implements Converter<JasperPrint, byte[]> {
    public byte[] convert(JasperPrint jasperPrint) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
            JasperExportManager.exportReportToXmlStream((JasperPrint)jasperPrint, (OutputStream)gzipOut);
            gzipOut.flush();
            baos.flush();
            gzipOut.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_JASPER, (Throwable)e);
        }
        catch (JRException e) {
            throw new ConversionException(ConversionErrorCode.CANNOT_CONVERT_JASPER, (Throwable)e);
        }
    }
}

