/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.model.Printer;
import javax.inject.Singleton;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

@Singleton
public class PrintServiceUtil {
    public PrintService[] getPrintServices() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        return printServices;
    }

    public PrintService getPrintService(String printerName) {
        PrintService[] services;
        PrintService service = null;
        for (PrintService printService : services = this.getPrintServices()) {
            if (!printService.getName().equals(printerName)) continue;
            service = printService;
            break;
        }
        return service;
    }

    public PrintService getDefaultPrintService() {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        return service;
    }

    public PrintService getPrintService(Job job) {
        Printer printer = job.getPrinter();
        PrintService printService = printer.getPrintService();
        if (printService == null) {
            printService = this.getPrintService(printer.getPrinterName());
        }
        return printService;
    }
}

