/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util;

import javax.print.DocPrintJob;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;

public class PrintJobWatcher {
    boolean done = false;

    public PrintJobWatcher(DocPrintJob job) {
        job.addPrintJobListener(new PrintJobAdapter(){

            @Override
            public void printJobCanceled(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobCompleted(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobFailed(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobNoMoreEvents(PrintJobEvent pje) {
                this.allDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void allDone() {
                PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                synchronized (printJobWatcher) {
                    PrintJobWatcher.this.done = true;
                    System.out.println("Printing done ...");
                    PrintJobWatcher.this.notify();
                }
            }
        });
    }

    public synchronized void waitForDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

