/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.util;

import br.com.sankhya.sps.annotation.configuration.ConfigUploadedDir;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.service.PrinterConfigService;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.print.DocFlavor;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@Singleton
public class JobUtil {
    private String uploadedDir;
    private PrinterConfigService printerConfigService;
    private static final Logger log = Logger.getLogger(JobUtil.class);

    @Inject
    public JobUtil(@ConfigUploadedDir String uploadedDir, PrinterConfigService printerConfigService) {
        this.uploadedDir = uploadedDir;
        this.printerConfigService = printerConfigService;
    }

    public String getFilePath(Job job) {
        String fileName = job.getFileName();
        DocTaste docTaste = job.getDocTaste();
        return this.getFilePath(fileName, docTaste);
    }

    public String getFilePath(String fileName, DocTaste docTaste) {
        Preconditions.checkNotNull((Object)fileName, (String)"O fileName n\u00e3o pode ser nulo");
        return this.uploadedDir + File.separator + fileName;
    }

    public void createJobFile(Job job, InputStream inputStream) throws IOException {
        String filePath = this.getFilePath(job);
        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
    }

    public InputStream getOldFileStream(Job oldJob) throws FileNotFoundException {
        String filePath = this.getFilePath(oldJob);
        FileInputStream fileInputStream = new FileInputStream(filePath);
        return fileInputStream;
    }

    public boolean jobFileExists(Job job) {
        Preconditions.checkNotNull((Object)job, (String)"N\u00e3o \u00e9 poss\u00edvel verificar a exist\u00eancia do arquivo do Job");
        String fileName = job.getFileName();
        Preconditions.checkNotNull((Object)fileName, (String)"N\u00e3o \u00e9 poss\u00edvel verificar a exist\u00eancia do arquivo do Job");
        String filePath = this.getFilePath(job);
        File file = new File(filePath);
        return file.exists();
    }

    public void deleteJobFile(Job job) throws IOException {
        Preconditions.checkNotNull((Object)job, (String)"N\u00e3o \u00e9 poss\u00edvel apagar um arquivo de um Job nulo");
        String fileName = job.getFileName();
        Preconditions.checkNotNull((Object)fileName, (String)"N\u00e3o \u00e9 poss\u00edvel apagar um arquivo de um Job cujo nome do arquivo \u00e9 nulo");
        String filePath = this.getFilePath(job);
        File file = new File(filePath);
        boolean deleted = file.delete();
        if (!deleted) {
            throw new IOException("Arquivo '" + fileName + "' n\u00e3o pode ser removido");
        }
    }

    public DocFlavor getDocFlavor(Job job) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        DocTaste docTaste = job.getDocTaste();
        String printerName = job.getPrinter().getPrinterName();
        PrinterConfig printerConfig = this.printerConfigService.findByPrinterNameAndDocTaste(printerName, docTaste);
        if (printerConfig != null) {
            log.debug((Object)("********* DocFlavor da printerConfig: " + printerConfig.getDocFlavorMetaData().getDocFlavor()));
            return printerConfig.getDocFlavorMetaData().getDocFlavor();
        }
        log.debug((Object)("********* DocFlavor padr\u00e3o: " + docTaste.getDefaultDocFlavor()));
        return docTaste.getDefaultDocFlavor();
    }

    public static String getJobsToDisposeInOneDay() {
        String[] statusToDiscardInADayArr = new String[]{"'READY'", "'SENDING'", "'PRINTING'", "'WAITING'", "'REQUIRE_ATTENTION'"};
        return JobUtil.joinWithSeparator(statusToDiscardInADayArr, ",");
    }

    public static String getJobsToDisposeInMinutes() {
        String[] statusToDiscardInMinutesArr = new String[]{"'DONE'", "'ERROR'", "'CANCELED'", "'UNKNOWN'"};
        return JobUtil.joinWithSeparator(statusToDiscardInMinutesArr, ",");
    }

    public static String joinWithSeparator(String[] arr, String separator) {
        if (null == arr || 0 == arr.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(separator).append(arr[i]);
        }
        return sb.toString();
    }
}

