/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.module;

import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.enumeration.DocType;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.http.extractor.HeaderExtractor;
import br.com.sankhya.sps.http.extractor.header.HttpHeaderExtractor;
import br.com.sankhya.sps.http.extractor.param.HttpRequestParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.param.AvailablePrinterValidator;
import br.com.sankhya.sps.http.validation.param.EnumValidator;
import br.com.sankhya.sps.http.validation.param.IntegerValidator;
import br.com.sankhya.sps.http.validation.param.LongValidator;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import br.com.sankhya.sps.http.validation.request.ClientIpValidator;
import br.com.sankhya.sps.http.validation.request.HasInputStreamValidator;
import br.com.sankhya.sps.util.PrintServiceUtil;
import br.com.sankhya.sps.util.RequestUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;

public class ValidationModule
extends AbstractModule {
    protected void configure() {
        this.bind(HeaderExtractor.class).to(HttpHeaderExtractor.class);
    }

    @Provides
    @Named(value="PrintRequestDataValidator")
    public Validator createPrintRequestValidator(HttpRequestParameterExtractor parameterExtractor, HeaderExtractor headerParameterExtractor, PrinterService printerService, RequestUtil requestUtil, PrintServiceUtil printServiceUtil) {
        HasInputStreamValidator hasInputStreamValidator = new HasInputStreamValidator();
        RequiredValidator requiredPrinterNameValidator = new RequiredValidator("printerName", parameterExtractor);
        AvailablePrinterValidator availablePrinterValidator = new AvailablePrinterValidator(printerService, printServiceUtil, "printerName", parameterExtractor);
        RequiredValidator requiredJobNameValidator = new RequiredValidator("jobDescription", parameterExtractor);
        RequiredValidator requiredMimeTypeValidator = new RequiredValidator("mimeType", parameterExtractor);
        EnumValidator<DocTaste> mimeTypeValidator = new EnumValidator<DocTaste>(DocTaste.class, "mimeType", parameterExtractor);
        RequiredValidator requiredUserNameValidator = new RequiredValidator("userName", parameterExtractor);
        RequiredValidator requiredUserIdValidator = new RequiredValidator("userId", parameterExtractor);
        RequiredValidator requiredCopiesValidator = new RequiredValidator("copies", parameterExtractor);
        IntegerValidator validIntCopiesValidator = new IntegerValidator("copies", parameterExtractor);
        RequiredValidator requiredDocTypeValidator = new RequiredValidator("docType", parameterExtractor);
        EnumValidator<DocType> docTypeValidator = new EnumValidator<DocType>(DocType.class, "docType", parameterExtractor);
        ClientIpValidator requiredClientIpValidator = new ClientIpValidator("clientIp", requestUtil);
        CompositeValidator validator = new CompositeValidator(hasInputStreamValidator, requiredPrinterNameValidator, availablePrinterValidator, requiredJobNameValidator, requiredMimeTypeValidator, mimeTypeValidator, requiredUserNameValidator, requiredUserIdValidator, requiredCopiesValidator, validIntCopiesValidator, requiredDocTypeValidator, docTypeValidator, requiredClientIpValidator);
        return validator;
    }

    @Provides
    @Named(value="ListJobsRequestDataValidator")
    public Validator createListJobsRequestDataValidator(HttpRequestParameterExtractor parameterExtractor, PrinterService printerService, PrintServiceUtil printServiceUtil) {
        RequiredValidator requiredPrinterNameValidator = new RequiredValidator("printerName", parameterExtractor);
        AvailablePrinterValidator availablePrinterValidator = new AvailablePrinterValidator(printerService, printServiceUtil, "printerName", parameterExtractor);
        LongValidator validLongJobIdValidator = new LongValidator("jobId", parameterExtractor);
        EnumValidator<JobStatus> jobStatusValidator = new EnumValidator<JobStatus>(JobStatus.class, "jobStatus", parameterExtractor);
        LongValidator validLongUserIdValidator = new LongValidator("userId", parameterExtractor);
        CompositeValidator validator = new CompositeValidator(requiredPrinterNameValidator, availablePrinterValidator, validLongJobIdValidator, jobStatusValidator, validLongUserIdValidator);
        return validator;
    }
}

