/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.module;

import br.com.sankhya.sps.annotation.configuration.ConfigHmacSalt;
import br.com.sankhya.sps.annotation.configuration.ConfigHmacSecretKey;
import br.com.sankhya.sps.annotation.type.HmacEncryptor;
import br.com.sankhya.sps.annotation.type.PasswordEncryptor;
import br.com.sankhya.sps.annotation.type.loader.AutoSense;
import br.com.sankhya.sps.annotation.type.loader.Jasper;
import br.com.sankhya.sps.annotation.type.loader.TextDoc;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.crypto.HmacSHA256Encriptor;
import br.com.sankhya.sps.crypto.MD5Encryptor;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.initializer.Initializer;
import br.com.sankhya.sps.initializer.PrintersInitializer;
import br.com.sankhya.sps.initializer.UploadedDirectoryInitializer;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.print.DocumentPrinterUtil;
import br.com.sankhya.sps.util.print.builder.AutoSenseDocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.builder.JasperPrintDocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.builder.TextDocumentPrinterBuilder;
import br.com.sankhya.sps.util.print.loader.DocumentLoader;
import br.com.sankhya.sps.util.print.loader.InputStreamDocumentLoader;
import br.com.sankhya.sps.util.print.loader.JasperPrintDocumentLoader;
import br.com.sankhya.sps.util.print.loader.TextDocumentLoader;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class UtilsModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @PasswordEncryptor
    public Encryptor createMD5Encryptor() {
        return new MD5Encryptor();
    }

    @Provides
    @HmacEncryptor
    public Encryptor createHmacEncriptor(@ConfigHmacSecretKey String secretKey, @ConfigHmacSalt String salt) {
        return new HmacSHA256Encriptor(secretKey, salt);
    }

    @Provides
    public DocumentPrinterUtil createDocumentPrinterUtil(AutoSenseDocumentPrinterBuilder autoSenseDocumentPrinterBuilder, JasperPrintDocumentPrinterBuilder jasperPrintDocumentPrinterBuilder, TextDocumentPrinterBuilder textDocumentPrinterBuilder) {
        DocumentPrinterUtil documentPrinterUtil = new DocumentPrinterUtil();
        documentPrinterUtil.put(DocTaste.AUTO, autoSenseDocumentPrinterBuilder);
        documentPrinterUtil.put(DocTaste.FILE, autoSenseDocumentPrinterBuilder);
        documentPrinterUtil.put(DocTaste.JASPER, jasperPrintDocumentPrinterBuilder);
        documentPrinterUtil.put(DocTaste.PDF, autoSenseDocumentPrinterBuilder);
        documentPrinterUtil.put(DocTaste.TEXT, textDocumentPrinterBuilder);
        return documentPrinterUtil;
    }

    @Provides
    @AutoSense
    public DocumentLoader<InputStream> createInputStreamDocumentLoader(JobUtil jobUtil) {
        return new InputStreamDocumentLoader(jobUtil);
    }

    @Provides
    @Jasper
    public DocumentLoader<JasperPrint> createJasperPrintDocumentLoader(JobUtil jobUtil, ConversionUtil conversionUtil) {
        return new JasperPrintDocumentLoader(jobUtil, conversionUtil);
    }

    @Provides
    @TextDoc
    public DocumentLoader<String> createtextDocDocumentLoader(JobUtil jobUtil) {
        return new TextDocumentLoader(jobUtil);
    }

    @Provides
    public List<Initializer> createInitializers(UploadedDirectoryInitializer uploadedDirectoryInitializer, PrintersInitializer printersInitializer) {
        ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        initializers.add(uploadedDirectoryInitializer);
        initializers.add(printersInitializer);
        return initializers;
    }
}

