/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.module;

import br.com.sankhya.sps.annotation.configuration.ConfigAboutCopyright;
import br.com.sankhya.sps.annotation.configuration.ConfigAboutMessage;
import br.com.sankhya.sps.annotation.configuration.ConfigDatabaseDriver;
import br.com.sankhya.sps.annotation.configuration.ConfigDatabasePassword;
import br.com.sankhya.sps.annotation.configuration.ConfigDatabaseUrl;
import br.com.sankhya.sps.annotation.configuration.ConfigDatabaseUser;
import br.com.sankhya.sps.annotation.configuration.ConfigGhostScriptPath;
import br.com.sankhya.sps.annotation.configuration.ConfigHmacSalt;
import br.com.sankhya.sps.annotation.configuration.ConfigHmacSecretKey;
import br.com.sankhya.sps.annotation.configuration.ConfigHttpServerPort;
import br.com.sankhya.sps.annotation.configuration.ConfigJobTimeout;
import br.com.sankhya.sps.annotation.configuration.ConfigPersistenceUnit;
import br.com.sankhya.sps.annotation.configuration.ConfigShutdownTime;
import br.com.sankhya.sps.annotation.configuration.ConfigSpsVersion;
import br.com.sankhya.sps.annotation.configuration.ConfigUploadedDir;
import br.com.sankhya.sps.module.loader.FilePropertiesLoader;
import br.com.sankhya.sps.module.loader.PropertiesLoader;
import br.com.sankhya.sps.module.loader.ResourcesPropertiesLoader;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class PropertiesFileConfigModule
extends AbstractModule {
    protected void configure() {
        try {
            String configFile = this.getConfigFile();
            Properties properties = this.getConfigProperties(configFile);
            String appPropertiesFile = this.getAppPropertiesFile();
            Properties appProperties = this.getAppProperties(appPropertiesFile);
            appProperties.putAll((Map<?, ?>)properties);
            if (!appProperties.containsKey("dir.ghostscript.path")) {
                appProperties.put("dir.ghostscript.path", "");
            }
            Names.bindProperties((Binder)this.binder(), (Properties)appProperties);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Problema ao carregar o arquivo de configura\u00e7\u00e3o", e);
        }
    }

    protected String getConfigFile() {
        return "./conf/config.properties";
    }

    protected String getAppPropertiesFile() {
        return "/br/com/sankhya/sps/resources/app.properties";
    }

    protected Properties getConfigProperties(String path) throws IOException {
        Properties properties = this.getConfigPropertiesLoader().loadProperties(path);
        return properties;
    }

    protected Properties getAppProperties(String path) throws IOException {
        Properties properties = this.getAppPropertiesLoader().loadProperties(path);
        return properties;
    }

    protected PropertiesLoader getConfigPropertiesLoader() {
        return new FilePropertiesLoader();
    }

    protected PropertiesLoader getAppPropertiesLoader() {
        return new ResourcesPropertiesLoader();
    }

    @Provides
    @ConfigAboutCopyright
    public String getConfigAboutCopyright(@Named(value="about.copyright") String property) {
        return property;
    }

    @Provides
    @ConfigAboutMessage
    public String getConfigAboutMessage(@Named(value="about.message") String property) {
        return property;
    }

    @Provides
    @ConfigSpsVersion
    public String getConfigSpsVersion(@Named(value="sps.version") String property) {
        return property;
    }

    @Provides
    @ConfigDatabaseDriver
    public String getConfigDatabaseDriver(@Named(value="database.driver") String property) {
        return property;
    }

    @Provides
    @ConfigDatabaseUrl
    public String getConfigDatabaseUrl(@Named(value="database.url") String property) {
        return property;
    }

    @Provides
    @ConfigDatabaseUser
    public String getConfigDatabaseUser(@Named(value="database.user") String property) {
        return property;
    }

    @Provides
    @ConfigDatabasePassword
    public String getConfigDatabasePassword(@Named(value="database.password") String property) {
        return property;
    }

    @Provides
    @ConfigHmacSalt
    public String getConfigHmacSalt(@Named(value="crypto.hmac.salt") String property) {
        return property;
    }

    @Provides
    @ConfigHmacSecretKey
    public String getConfigHmacSecretKey(@Named(value="crypto.hmac.secretkey") String property) {
        return property;
    }

    @Provides
    @ConfigHttpServerPort
    public Integer getConfigHttpServerPort(@Named(value="server.http.port") String property) {
        Integer propertyInteger = Integer.valueOf(property);
        return propertyInteger;
    }

    @Provides
    @ConfigPersistenceUnit
    public String getConfigPersistenceUnitName(@Named(value="database.persistence.unit") String property) {
        return property;
    }

    @Provides
    @ConfigShutdownTime
    public Long getConfigShutdownTime(@Named(value="system.shutdown.time") String property) {
        Long propertyLong = Long.valueOf(property);
        return propertyLong;
    }

    @Provides
    @ConfigJobTimeout
    public Integer getConfigJobTimeoutgetConfigPrintServerPort(@Named(value="job.timeout") String property) {
        Integer propertyInteger = Integer.valueOf(property);
        return propertyInteger;
    }

    @Provides
    @ConfigUploadedDir
    public String getConfigUploadedDir(@Named(value="dir.uploaded") String property) {
        String filepath = FilenameUtils.separatorsToSystem((String)property);
        return filepath;
    }

    @Provides
    @ConfigGhostScriptPath
    public String getConfigConfigGhostScriptPath(@Named(value="dir.ghostscript.path") String property) {
        String filepath = FilenameUtils.separatorsToSystem((String)property);
        return filepath;
    }
}

