/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.module;

import br.com.sankhya.sps.annotation.configuration.ConfigPersistenceUnit;
import br.com.sankhya.sps.annotation.type.HmacEncryptor;
import br.com.sankhya.sps.annotation.type.PasswordEncryptor;
import br.com.sankhya.sps.business.repository.ApiKeyRepository;
import br.com.sankhya.sps.business.repository.JobRepository;
import br.com.sankhya.sps.business.repository.PrinterConfigRepository;
import br.com.sankhya.sps.business.repository.PrinterRepository;
import br.com.sankhya.sps.business.repository.UserRepository;
import br.com.sankhya.sps.business.service.AuthenticationService;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.business.service.PrinterConfigService;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.concurrent.PrinterQueueManager;
import br.com.sankhya.sps.concurrent.tasks.DeleteoldJobsTask;
import br.com.sankhya.sps.concurrent.tasks.FixedDelayTask;
import br.com.sankhya.sps.concurrent.tasks.RenewApiKeysTask;
import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.PrintServiceUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class BusinessModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    public EntityManagerFactory createEntityManagerFactory(@ConfigPersistenceUnit String persistenceUnit) {
        return Persistence.createEntityManagerFactory((String)persistenceUnit);
    }

    @Provides
    public ApiKeyRepository createApiKeyRepository(EntityManagerFactory entityManagerFactory) {
        return new ApiKeyRepository(entityManagerFactory);
    }

    @Provides
    public JobRepository createJobRepository(EntityManagerFactory entityManagerFactory) {
        return new JobRepository(entityManagerFactory);
    }

    @Provides
    public PrinterRepository createPrinterRepository(EntityManagerFactory entityManagerFactory) {
        return new PrinterRepository(entityManagerFactory);
    }

    @Provides
    public PrinterConfigRepository createPrinterConfigRepository(EntityManagerFactory entityManagerFactory) {
        return new PrinterConfigRepository(entityManagerFactory);
    }

    @Provides
    public UserRepository createUserRepository(EntityManagerFactory entityManagerFactory, @PasswordEncryptor Encryptor encryptor) {
        return new UserRepository(entityManagerFactory, encryptor);
    }

    @Provides
    public AuthenticationService createAuthenticationService(@PasswordEncryptor Encryptor passwordEncryptor, @HmacEncryptor Encryptor hmacEncryptor, UserRepository userRepository, ApiKeyRepository apiKeyRepository) {
        return new AuthenticationService(userRepository, passwordEncryptor, hmacEncryptor, apiKeyRepository);
    }

    @Provides
    public JobService createJobService(JobRepository jobRepository, PrinterRepository printerRepository, PrinterQueueManager printerQueueManager, JobUtil jobUtil) {
        return new JobService(jobRepository, printerRepository, printerQueueManager, jobUtil);
    }

    @Provides
    public PrinterService createPrinterService(PrinterRepository printerRepository, PrintServiceUtil printServiceUtil, PrinterConfigRepository printerConfigRepository, JobRepository jobRepository) {
        return new PrinterService(printerRepository, printServiceUtil, printerConfigRepository, jobRepository);
    }

    @Provides
    public PrinterConfigService createPrinterConfigService(PrinterConfigRepository printerConfigRepository) {
        return new PrinterConfigService(printerConfigRepository);
    }

    @Provides
    public List<FixedDelayTask> createFixedDelayTasks(AuthenticationService authenticationService, JobService jobService) {
        ArrayList<FixedDelayTask> fixedDelayTasks = new ArrayList<FixedDelayTask>();
        fixedDelayTasks.add(new RenewApiKeysTask(60L, 0L, TimeUnit.SECONDS, authenticationService));
        fixedDelayTasks.add(new DeleteoldJobsTask(1L, 0L, TimeUnit.HOURS, jobService));
        return fixedDelayTasks;
    }
}

