/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.initializer;

import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.repository.PrinterConfigRepository;
import br.com.sankhya.sps.business.repository.PrinterRepository;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.enumeration.PrinterStatus;
import br.com.sankhya.sps.initializer.Initializer;
import br.com.sankhya.sps.util.PrintServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.print.PrintService;
import org.apache.log4j.Logger;

@Singleton
public class PrintersInitializer
implements Initializer {
    private static Logger log = Logger.getLogger(PrintersInitializer.class);
    @Inject
    private PrintServiceUtil printServiceUtil;
    @Inject
    private PrinterRepository printerRepository;
    @Inject
    private PrinterConfigRepository printerConfigRepository;

    @Override
    public void init() throws Exception {
        log.info((Object)"Inicializando configura\u00e7\u00e3o de impressoras");
        PrintService[] printServices = this.printServiceUtil.getPrintServices();
        ArrayList<Printer> printersOnServer = new ArrayList<Printer>();
        Printer printer = null;
        for (PrintService printService : printServices) {
            printer = Printer.buildPrinter(printService);
            printersOnServer.add(printer);
        }
        List printersOnDB = this.printerRepository.findAll();
        HashMap<String, Printer> printers = new HashMap<String, Printer>();
        for (Printer p : printersOnServer) {
            printers.put(p.getPrinterName(), p);
        }
        for (Printer p : printersOnDB) {
            if (!printers.containsKey(p.getPrinterName())) {
                log.info((Object)("Impressora " + p.getPrinterName() + " n\u00e3o est\u00e1 mais dispon\u00edvel"));
                p.setPrinterStatus(PrinterStatus.UNKNOWN);
                printers.put(p.getPrinterName(), p);
                continue;
            }
            printer = (Printer)printers.get(p.getPrinterName());
            printer.setId(p.getId());
        }
        DocTaste[] values = DocTaste.values();
        PrinterConfig printerConfig = null;
        for (Map.Entry entry : printers.entrySet()) {
            printer = (Printer)entry.getValue();
            if (printer.getId() == null) {
                this.printerRepository.create(printer);
            } else {
                this.printerRepository.update(printer);
            }
            for (DocTaste docTaste : values) {
                printerConfig = this.printerConfigRepository.findByPrinterNameAndDocTaste(printer.getPrinterName(), docTaste);
                if (printerConfig != null) continue;
                printerConfig = new PrinterConfig();
                printerConfig.setDocTaste(docTaste);
                printerConfig.setPrinter(printer);
                printerConfig.setDocFlavorMetaData(docTaste.getDefaultDocFlavorMetaData());
                this.printerConfigRepository.create(printerConfig);
            }
        }
    }
}

