/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.validation.param;

import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.param.AbstractParamValidator;
import com.sankhya.util.StringUtils;

public class LongArrayValidator
extends AbstractParamValidator {
    public LongArrayValidator(String paramName, ParameterExtractor parameterExtractor, String message) {
        super(paramName, parameterExtractor, message);
    }

    public LongArrayValidator(String paramName, ParameterExtractor parameterExtractor) {
        super(paramName, parameterExtractor);
    }

    @Override
    public ValidationResult validate(RealRequestServiceContext context) {
        ValidationResult validationResult = new ValidationResult();
        String param = this.getParameterExtractor().getParameterString(context, this.paramName);
        if (!StringUtils.isEmpty((String)param)) {
            String[] numbers;
            for (String number : numbers = param.split(";")) {
                try {
                    Long.parseLong(number);
                }
                catch (NumberFormatException e) {
                    String errorMessage = this.message == null ? "O par\u00e2metro " + this.paramName + " deve conter apenas n\u00fameros" : this.message;
                    validationResult.addValidationError(new ValidationError(this.paramName, errorMessage, this.getClass().getSimpleName()));
                    break;
                }
            }
        }
        return validationResult;
    }
}

