/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.validation.param;

import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.param.AbstractParamValidator;
import com.sankhya.util.StringUtils;

public class EnumValidator<E extends Enum<E>>
extends AbstractParamValidator {
    private Class<E> enumClass;

    public EnumValidator(Class<E> enumClass, String paramName, ParameterExtractor parameterExtractor, String message) {
        super(paramName, parameterExtractor, message);
        this.enumClass = enumClass;
    }

    public EnumValidator(Class<E> enumClass, String paramName, ParameterExtractor parameterExtractor) {
        super(paramName, parameterExtractor);
        this.enumClass = enumClass;
    }

    @Override
    public ValidationResult validate(RealRequestServiceContext context) {
        ValidationResult validationResult = new ValidationResult();
        String param = this.getParameterExtractor().getParameterString(context, this.paramName);
        if (!StringUtils.isEmpty((String)param)) {
            try {
                Enum.valueOf(this.enumClass, param);
            }
            catch (IllegalArgumentException e) {
                String errorMessage = this.message == null ? "Par\u00e2metro " + this.paramName + " inv\u00e1lido" : this.message;
                validationResult.addValidationError(new ValidationError(this.paramName, errorMessage, this.getClass().getSimpleName()));
            }
        }
        return validationResult;
    }
}

