/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.validation.param;

import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.param.AbstractParamValidator;
import com.sankhya.util.StringUtils;

public class ConfirmPasswordValidator
extends AbstractParamValidator {
    private String confirmPasswordParamName;

    public ConfirmPasswordValidator(String passwordParamName, String confirmPasswordParamName, ParameterExtractor parameterExtractor) {
        super(passwordParamName, parameterExtractor);
        this.confirmPasswordParamName = confirmPasswordParamName;
    }

    public ConfirmPasswordValidator(String passwordParamName, String confirmPasswordParamName, ParameterExtractor parameterExtractor, String message) {
        super(passwordParamName, parameterExtractor, message);
        this.confirmPasswordParamName = confirmPasswordParamName;
    }

    @Override
    public ValidationResult validate(RealRequestServiceContext context) {
        String passwordParam = this.getParameterExtractor().getParameterString(context, this.paramName);
        String confirmPasswordParam = this.getParameterExtractor().getParameterString(context, this.confirmPasswordParamName);
        ValidationResult validationResult = new ValidationResult();
        if (!StringUtils.safelyEquals((Object)passwordParam, (Object)confirmPasswordParam)) {
            String errorMessage = this.message == null ? "A senha e a confirma\u00e7\u00e3o de senha devem ser iguais" : this.message;
            validationResult.addValidationError(new ValidationError(this.paramName, errorMessage, this.getClass().getSimpleName()));
        }
        return validationResult;
    }
}

