/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.validation.param;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.enumeration.PrinterStatus;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.param.AbstractParamValidator;
import br.com.sankhya.sps.util.PrintServiceUtil;
import com.sankhya.util.StringUtils;
import javax.print.PrintService;

public class AvailablePrinterValidator
extends AbstractParamValidator {
    private static final String DEFAULT_PARAM_NAME = "printerName";
    private PrinterService printerService;
    private PrintServiceUtil printServiceUtil;

    public AvailablePrinterValidator(PrinterService printerService, PrintServiceUtil printServiceUtil, String paramName, ParameterExtractor parameterExtractor, String message) {
        super(paramName, parameterExtractor, message);
        this.printerService = printerService;
        this.printServiceUtil = printServiceUtil;
    }

    public AvailablePrinterValidator(PrinterService printerService, PrintServiceUtil printServiceUtil, String paramName, ParameterExtractor parameterExtractor) {
        super(paramName, parameterExtractor);
        this.printerService = printerService;
        this.printServiceUtil = printServiceUtil;
    }

    public AvailablePrinterValidator(PrinterService printerService, PrintServiceUtil printServiceUtil, ParameterExtractor parameterExtractor, String message) {
        super(DEFAULT_PARAM_NAME, parameterExtractor, message);
        this.printerService = printerService;
        this.printServiceUtil = printServiceUtil;
    }

    public AvailablePrinterValidator(PrinterService printerService, PrintServiceUtil printServiceUtil, ParameterExtractor parameterExtractor) {
        super(DEFAULT_PARAM_NAME, parameterExtractor);
        this.printerService = printerService;
        this.printServiceUtil = printServiceUtil;
    }

    @Override
    public ValidationResult validate(RealRequestServiceContext context) {
        ValidationResult validationResult = new ValidationResult();
        String printerName = this.getParameterExtractor().getParameterString(context, this.paramName);
        if (!StringUtils.isEmpty((String)printerName)) {
            try {
                Printer printer = this.printerService.findPrinterByPrinterName(printerName);
                PrintService printService = this.printServiceUtil.getPrintService(printer.getPrinterName());
                if (printer.getPrinterStatus() == PrinterStatus.UNKNOWN || printService == null) {
                    validationResult.addValidationError(new ValidationError(this.paramName, "A impressora informada n\u00e3o est\u00e1 dispon\u00edvel: " + printerName, this.getClass().getSimpleName()));
                }
            }
            catch (BusinessException e) {
                validationResult.addValidationError(new ValidationError(this.paramName, "A impressora informada n\u00e3o foi localizada: " + printerName, this.getClass().getSimpleName()));
            }
        }
        return validationResult;
    }
}

