/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.validation.exception;

import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.exception.ErrorCode;
import br.com.sankhya.sps.http.validation.ValidationError;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.exception.ValidationErrorCode;
import java.io.PrintWriter;
import java.util.Map;

public class ValidationException
extends BaseException {
    private static final long serialVersionUID = -4015039317061904834L;
    private ValidationResult validationResult;

    public ValidationException(ValidationResult validationResult) {
        super((ErrorCode)ValidationErrorCode.VALIDATION_ERROR);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, String message, Throwable cause) {
        super((ErrorCode)ValidationErrorCode.VALIDATION_ERROR, message, cause);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, String message) {
        super((ErrorCode)ValidationErrorCode.VALIDATION_ERROR, message);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, Throwable cause) {
        super((ErrorCode)ValidationErrorCode.VALIDATION_ERROR, cause);
        this.validationResult = validationResult;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public ValidationException(ValidationResult validationResult, ErrorCode errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, ErrorCode errorCode, String message) {
        super(errorCode, message);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, ErrorCode errorCode, Throwable cause) {
        super(errorCode, cause);
        this.validationResult = validationResult;
    }

    public ValidationException(ValidationResult validationResult, ErrorCode errorCode) {
        super(errorCode);
        this.validationResult = validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println((Object)this);
            s.println("\t-------------------------------");
            if (this.getErrorCode() != null) {
                s.println("\t" + this.getErrorCode() + ":" + this.getErrorCode().getClass().getName());
            }
            s.println("\tProperties");
            s.println("\t\t-------------------------------");
            for (Map.Entry entry : this.getProperties().entrySet()) {
                s.println("\t\t" + entry.getKey() + "=[" + entry.getValue() + "]");
            }
            s.println("\tValidation Errors: " + this.validationResult.isValid());
            for (ValidationError va : this.validationResult.getValidationErrors()) {
                s.println("\t\t-------------------------------");
                s.println("\t\tValidation Type: " + va.getValidationType());
                s.println("\t\tContext: " + va.getErrorContext());
                s.println("\t\tMessage: " + va.getErrorMessage());
                s.println();
            }
            s.println("\t-------------------------------");
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTrace(s);
            }
            s.flush();
        }
    }
}

