/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.response;

import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.sps.annotation.configuration.ConfigSpsVersion;
import br.com.sankhya.sps.http.response.ResponseWriter;
import com.sankhya.util.Base64Impl;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Singleton
public class XmlResponseWriter
implements ResponseWriter {
    @ConfigSpsVersion
    @Inject
    private String spsVersion;

    @Override
    public void write(HttpResponse response, String serviceName, Element responseBody, int status, String statusMessage) throws IOException {
        Document doc = new Document();
        if (status == 0) {
            Element errorResponseBody = new Element("responseBody");
            errorResponseBody.setAttribute("spsVersion", this.spsVersion);
            Element errorReport = new Element("errorReport");
            errorResponseBody.addContent((Content)errorReport);
            errorReport.setAttribute("status", String.valueOf(status));
            CDATA cdata = new CDATA(Base64Impl.encode((byte[])statusMessage.getBytes()));
            Element statusMessageElement = new Element("statusMessage");
            statusMessageElement.addContent((Content)cdata);
            errorReport.addContent((Content)statusMessageElement);
            if (responseBody != null) {
                errorReport.addContent((Content)responseBody);
            }
            doc.addContent((Content)errorResponseBody);
        } else {
            responseBody.setAttribute("spsVersion", this.spsVersion);
            doc.addContent((Content)responseBody);
        }
        XMLOutputter outter = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setEncoding("ISO-8859-1");
        response.setContentType("text/xml");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        OutputStream out = response.getOutputStream();
        outter.setFormat(format);
        outter.output(doc, out);
    }
}

