/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.response;

import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.sps.annotation.configuration.ConfigSpsVersion;
import br.com.sankhya.sps.http.response.ResponseWriter;
import com.sankhya.util.Base64Impl;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Singleton
public class BrokerResponseWriter
implements ResponseWriter {
    @ConfigSpsVersion
    @Inject
    private String spsVersion;

    @Override
    public void write(HttpResponse response, String serviceName, Element responseBody, int status, String statusMessage) throws IOException {
        Document doc = new Document();
        Element rootElement = new Element("responseBody");
        doc.addContent((Content)rootElement);
        rootElement.setAttribute("serviceName", serviceName == null ? "unknown" : serviceName);
        rootElement.setAttribute("status", String.valueOf(status));
        rootElement.setAttribute("spsVersion", this.spsVersion);
        if (statusMessage != null) {
            CDATA cdata = new CDATA(Base64Impl.encode((byte[])statusMessage.getBytes()));
            Element statusMessageElement = new Element("statusMessage");
            statusMessageElement.addContent((Content)cdata);
            rootElement.addContent((Content)statusMessageElement);
        }
        if (status == 0) {
            Element errorReport = new Element("errorReport");
            errorReport.setAttribute("status", String.valueOf(status));
            if (responseBody != null) {
                errorReport.addContent((Content)responseBody);
            }
            rootElement.addContent((Content)errorReport);
        } else if (responseBody != null) {
            rootElement.addContent((Content)responseBody);
        }
        XMLOutputter outter = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setEncoding("ISO-8859-1");
        response.setContentType("text/xml");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        OutputStream out = response.getOutputStream();
        outter.setFormat(format);
        outter.output(doc, out);
    }
}

