/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.listener;

import br.com.sankhya.http.HttpListener;
import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.sps.http.HttpFilter;
import br.com.sankhya.sps.http.HttpFilterChain;
import br.com.sankhya.sps.http.filter.HttpFilterChainImpl;
import br.com.sankhya.sps.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HttpFilterListener
implements HttpListener,
HttpFilter {
    private static final Logger log = Logger.getLogger(HttpFilterListener.class);
    private List<HttpFilter> httpFilters;
    private HttpListener httpListener;

    public HttpFilterListener(List<HttpFilter> httpFilters, HttpListener httpListener) {
        Preconditions.checkNotNull((Object)httpListener);
        this.httpListener = httpListener;
        this.httpFilters = httpFilters != null ? httpFilters : new ArrayList<HttpFilter>();
        this.httpFilters.add(this);
    }

    public void processRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        log.debug((Object)"Criando Filter chain");
        HttpFilterChainImpl chain = new HttpFilterChainImpl(this.httpFilters);
        log.debug((Object)"Invocando chain.doFilter");
        chain.doFilter(httpRequest, httpResponse);
        log.debug((Object)"chain.doFilter invocado");
    }

    @Override
    public void doFilter(HttpRequest httpRequest, HttpResponse httpResponse, HttpFilterChain chain) throws Exception {
        log.debug((Object)"Invocando httpListener.processRequest");
        this.httpListener.processRequest(httpRequest, httpResponse);
        log.debug((Object)"httpListener.processRequest invocado");
    }
}

