/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.listener;

import br.com.sankhya.http.HttpListener;
import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.exception.BaseErrorCode;
import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.exception.ErrorCode;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.Command;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.response.ResponseWriter;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.jdom.Element;

@Singleton
public class CommandHttpListener
implements HttpListener {
    private static final Logger log = Logger.getLogger(CommandHttpListener.class);
    public static final String NOME_LOGIN_SESSION = "login_sess";
    private Map<String, Command> commands;
    private ResponseWriter responseWriter;
    private ConversionUtil conversionService;

    public CommandHttpListener(Map<String, Command> commands, ResponseWriter responseWriter, ConversionUtil conversionService) {
        this.commands = commands;
        this.responseWriter = responseWriter;
        this.conversionService = conversionService;
    }

    public void processRequest(HttpRequest httpRequest, HttpResponse response) throws Exception {
        String serviceName = httpRequest.getParameter("serviceName");
        int status = 1;
        String statusMessage = null;
        Element responseBody = null;
        try {
            if (serviceName == null) {
                throw new CommandException(CommandErrorCode.UNINFORMED_COMMAND);
            }
            Command command = this.commands.get(serviceName);
            if (command == null) {
                throw new CommandException(CommandErrorCode.COMMAND_NOT_FOUND).put("serviceName", serviceName);
            }
            RealRequestServiceContext context = new RealRequestServiceContext(httpRequest);
            command.execute(context);
            status = context.getStatus();
            statusMessage = context.getStatusMessage();
            responseBody = context.getBodyElement();
        }
        catch (BaseException e) {
            Element errorReport;
            log.debug((Object)"Ocorreu um erro durante o processamento do comando.", (Throwable)e);
            status = 0;
            responseBody = errorReport = (Element)this.conversionService.convert((Object)e, Element.class);
            statusMessage = (String)this.conversionService.convert((Object)errorReport, String.class);
        }
        catch (Exception e) {
            Element errorReport;
            log.debug((Object)"Ocorreu um erro durante o processamento do comando.", (Throwable)e);
            status = 0;
            BaseException baseException = new BaseException((ErrorCode)BaseErrorCode.UNEXPECTED_ERROR, (Throwable)e);
            responseBody = errorReport = (Element)this.conversionService.convert((Object)baseException, Element.class);
            statusMessage = (String)this.conversionService.convert((Object)errorReport, String.class);
        }
        this.responseWriter.write(response, serviceName, responseBody, status, statusMessage);
    }
}

