/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.filter;

import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.http.HttpSession;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.http.HttpFilter;
import br.com.sankhya.sps.http.HttpFilterChain;
import br.com.sankhya.sps.http.filter.exception.FilterErrorCode;
import br.com.sankhya.sps.http.filter.exception.FilterException;
import br.com.sankhya.sps.http.response.ResponseWriter;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class BrokerAuthenticationFilter
implements HttpFilter {
    private static final Logger log = Logger.getLogger(BrokerAuthenticationFilter.class);
    public static final String NOME_LOGIN_SESSION = "login_sess";
    private ResponseWriter responseWriter;
    private ConversionUtil conversionService;
    private Collection<String> noLoginCommandNames;

    public BrokerAuthenticationFilter(ResponseWriter responseWriter, ConversionUtil conversionService, Collection<String> noLoginCommandNames) {
        this.responseWriter = responseWriter;
        this.conversionService = conversionService;
        this.noLoginCommandNames = noLoginCommandNames;
    }

    @Override
    public void doFilter(HttpRequest httpRequest, HttpResponse httpResponse, HttpFilterChain chain) throws Exception {
        String serviceName = httpRequest.getParameter("serviceName");
        try {
            HttpSession session;
            String loginSession;
            if (serviceName == null) {
                throw new FilterException(FilterErrorCode.UNINFORMED_COMMAND);
            }
            if (!this.noLoginCommandNames.contains(serviceName) && (loginSession = (String)(session = httpRequest.getSession()).getAtribute(NOME_LOGIN_SESSION)) == null) {
                throw new FilterException(FilterErrorCode.ACCESS_DENIED, "Sua sess\u00e3o foi encerrada. Por favor, efetue login novamente.");
            }
            chain.doFilter(httpRequest, httpResponse);
        }
        catch (BaseException e) {
            Element errorReport;
            int status = 1;
            String statusMessage = null;
            Element responseBody = null;
            log.debug((Object)"Ocorreu um erro durante o processamento do filtro.", (Throwable)e);
            status = 0;
            responseBody = errorReport = (Element)this.conversionService.convert((Object)e, Element.class);
            statusMessage = (String)this.conversionService.convert((Object)errorReport, String.class);
            this.responseWriter.write(httpResponse, serviceName, responseBody, status, statusMessage);
        }
    }
}

