/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.filter;

import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.sps.business.model.ApiKey;
import br.com.sankhya.sps.business.service.AuthenticationService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.http.HttpFilter;
import br.com.sankhya.sps.http.HttpFilterChain;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.SpecialEncoder;
import br.com.sankhya.sps.http.extractor.HeaderExtractor;
import br.com.sankhya.sps.http.filter.exception.FilterErrorCode;
import br.com.sankhya.sps.http.filter.exception.FilterException;
import br.com.sankhya.sps.http.response.ResponseWriter;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ApiKeyAuthenticationFilter
implements HttpFilter {
    private static final Logger log = Logger.getLogger(ApiKeyAuthenticationFilter.class);
    private HeaderExtractor headerExtractor;
    private ResponseWriter responseWriter;
    private ConversionUtil conversionService;
    private AuthenticationService authenticationService;
    private Collection<String> noLoginCommandNames;

    public ApiKeyAuthenticationFilter(HeaderExtractor headerExtractor, ResponseWriter responseWriter, ConversionUtil conversionService, AuthenticationService authenticationService, Collection<String> noLoginCommandNames) {
        this.headerExtractor = headerExtractor;
        this.responseWriter = responseWriter;
        this.conversionService = conversionService;
        this.authenticationService = authenticationService;
        this.noLoginCommandNames = noLoginCommandNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doFilter(HttpRequest httpRequest, HttpResponse httpResponse, HttpFilterChain chain) throws Exception {
        RealRequestServiceContext context = new RealRequestServiceContext(httpRequest);
        String hmac = this.headerExtractor.getHeader(context, "hmac");
        String apiKey = this.headerExtractor.getHeader(context, "apiKey");
        try {
            if (!this.requiresAuthentication(httpRequest)) {
                chain.doFilter(httpRequest, httpResponse);
                return;
            }
            if (hmac == null || apiKey == null) {
                log.debug((Object)"Credenciais n\u00e3o encontradas");
                throw new FilterException(FilterErrorCode.CREDENTIALS_NOT_FOUND);
            }
            log.debug((Object)"Credenciais encontradas");
            boolean authenticated = this.isAuthenticated(hmac, apiKey, httpRequest);
            if (authenticated) {
                log.debug((Object)"Autenticado");
                chain.doFilter(httpRequest, httpResponse);
                return;
            }
            log.debug((Object)"N\u00e3o autenticado");
            throw new FilterException(FilterErrorCode.ACCESS_DENIED);
        }
        catch (BaseException e) {
            Element errorReport;
            String serviceName = httpRequest.getParameter("serviceName");
            int status = 0;
            String statusMessage = null;
            Element responseBody = null;
            if (apiKey != null) {
                e.put("apiKey", (Object)apiKey);
            }
            if (hmac != null) {
                e.put("hmac", (Object)hmac);
            }
            log.debug((Object)"Ocorreu um erro durante o processamento do filtro.", (Throwable)e);
            status = 0;
            responseBody = errorReport = (Element)this.conversionService.convert((Object)e, Element.class);
            statusMessage = (String)this.conversionService.convert((Object)errorReport, String.class);
            this.responseWriter.write(httpResponse, serviceName, responseBody, status, statusMessage);
        }
    }

    private boolean isAuthenticated(String hmac, String apiKey, HttpRequest httpRequest) {
        ApiKey validApikey = this.authenticationService.findValidApikey(apiKey);
        if (validApikey == null) {
            log.debug((Object)("Api key n\u00e3o encontrada: " + apiKey));
            return false;
        }
        String uri = httpRequest.getHttpRequest().getRequestLine().getUri();
        int questionIndex = uri.indexOf("?");
        String app = uri.substring(0, questionIndex);
        String params = uri.substring(questionIndex, uri.length());
        String encodedParams = SpecialEncoder.encode((String)params);
        String encodedUri = app + encodedParams;
        log.debug((Object)("URL invocada: " + uri));
        log.debug((Object)("Encoded URL: " + encodedUri));
        boolean validHmac = this.authenticationService.isValidHmac(encodedUri, validApikey, hmac);
        log.debug((Object)("HMAC v\u00e1lido? " + validHmac));
        return validHmac;
    }

    protected boolean requiresAuthentication(HttpRequest httpRequest) {
        String commandName = httpRequest.getParameter("serviceName");
        return !this.noLoginCommandNames.contains(commandName);
    }
}

