/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.extractor.header;

import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.extractor.HeaderExtractor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Singleton;
import org.apache.http.Header;

@Singleton
public class HttpHeaderExtractor
implements HeaderExtractor {
    @Override
    public String getHeader(RealRequestServiceContext context, String name) {
        Header firstHeader;
        HttpRequest request = (HttpRequest)context.getHttpRequest();
        String header = request.getHeader(name);
        if (header == null && (firstHeader = request.getHttpRequest().getFirstHeader(name)) != null) {
            header = firstHeader.getValue();
        }
        return header;
    }

    @Override
    public List<String> getHeaderNames(RealRequestServiceContext context) {
        Header[] headersArray;
        HttpRequest request = (HttpRequest)context.getHttpRequest();
        ArrayList<String> headerList = new ArrayList<String>();
        Enumeration headerNamesEnumeration = request.getHeaderNames();
        if (headerNamesEnumeration != null && headerNamesEnumeration.hasMoreElements()) {
            String nextHeader = (String)headerNamesEnumeration.nextElement();
            while (nextHeader != null) {
                headerList.add(nextHeader);
                nextHeader = (String)headerNamesEnumeration.nextElement();
            }
        }
        if ((headersArray = request.getHttpRequest().getAllHeaders()) != null && headersArray.length > 0) {
            for (Header header : headersArray) {
                headerList.add(header.getName());
            }
        }
        return headerList;
    }
}

