/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.security;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.profile.SPSConfigs;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class LoginStatusCommand
extends AbstractCommand {
    SPSConfigs spsConfigs = SPSConfigs.getInstance();

    @Inject
    public LoginStatusCommand(ParameterExtractor parameterExtractor) {
        super(parameterExtractor);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        try {
            String username;
            Element ret = new Element("result");
            HttpServletRequest request = context.getHttpRequest();
            HttpSession session = request.getSession();
            if (session != null && (username = (String)session.getAttribute("login_sess")) != null) {
                ret.setAttribute("status", "l");
            }
            if (this.spsConfigs.getProfile().isSankhyaProfile()) {
                ret.setAttribute("isSankhyaProfile", "true");
            } else {
                ret.setAttribute("isSankhyaProfile", "false");
            }
            context.getBodyElement().addContent((Content)ret);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_VERIFY_LOGIN_STATUS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

