/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.security;

import br.com.sankhya.sps.business.service.AuthenticationService;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class LoginCommand
extends AbstractCommand {
    private AuthenticationService authenticationService;
    private Validator validator;

    @Inject
    public LoginCommand(ParameterExtractor parameterExtractor, AuthenticationService authenticationService) {
        super(parameterExtractor);
        this.authenticationService = authenticationService;
        RequiredValidator requiredUserValidator = new RequiredValidator("usuario", this.getParameterExtractor());
        RequiredValidator requiredPasswordValidator = new RequiredValidator("senha", this.getParameterExtractor());
        this.validator = new CompositeValidator(requiredUserValidator, requiredPasswordValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String username = this.getParameterExtractor().getParameterString(context, "usuario");
        String password = this.getParameterExtractor().getParameterString(context, "senha");
        try {
            HttpServletRequest request = context.getHttpRequest();
            if (!this.authenticationService.isValidUser(username, password)) {
                throw new CommandException(CommandErrorCode.INVALID_USER_PASSWORD);
            }
            request.getSession().setAttribute("login_sess", (Object)username);
            Element retElem = new Element("retlogin");
            retElem.setText("1");
            context.getBodyElement().addContent((Content)retElem);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.CANNOT_LOGIN, e);
        }
    }
}

