/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.security;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.ApiKey;
import br.com.sankhya.sps.business.service.AuthenticationService;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import org.jdom.Content;
import org.jdom.Element;

public class GetApiKeyCommand
extends AbstractCommand {
    private AuthenticationService authenticationService;

    public GetApiKeyCommand(ParameterExtractor parameterExtractor, AuthenticationService authenticationService) {
        super(parameterExtractor);
        this.authenticationService = authenticationService;
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        try {
            ApiKey apiKey = this.authenticationService.getLastApiKey();
            Element retElem = new Element("apiKey");
            retElem.setText(apiKey.toString());
            Element bodyElement = context.getBodyElement();
            bodyElement.addContent((Content)retElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CHANGE_PASSWORD_ERROR, e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

