/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.security;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.service.AuthenticationService;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.ConfirmPasswordValidator;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class ChangePasswordCommand
extends AbstractCommand {
    private Validator validator;
    private AuthenticationService authenticationService;

    @Inject
    public ChangePasswordCommand(ParameterExtractor parameterExtractor, AuthenticationService authenticationService) {
        super(parameterExtractor);
        this.authenticationService = authenticationService;
        RequiredValidator requiredUserNameValidator = new RequiredValidator("userName", this.getParameterExtractor());
        RequiredValidator requiredCurrentPasswordValidator = new RequiredValidator("currentPassword", this.getParameterExtractor(), "A senha atual \u00e9 obrigat\u00f3ria");
        RequiredValidator requiredNewPasswordValidator = new RequiredValidator("newPassword", this.getParameterExtractor(), "A senha nova \u00e9 obrigat\u00f3ria");
        RequiredValidator requiredConfirmPasswordValidator = new RequiredValidator("confirmPassword", this.getParameterExtractor(), "A confirma\u00e7\u00e3o de senha \u00e9 obrigat\u00f3ria");
        ConfirmPasswordValidator confirmPasswordValidator = new ConfirmPasswordValidator("newPassword", "confirmPassword", this.getParameterExtractor(), "A senha nova e a confirma\u00e7\u00e3o de senha devem ser iguais");
        this.validator = new CompositeValidator(requiredUserNameValidator, requiredCurrentPasswordValidator, requiredNewPasswordValidator, requiredConfirmPasswordValidator, confirmPasswordValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String userName = this.getParameterExtractor().getParameterString(context, "userName");
        String currentPassword = this.getParameterExtractor().getParameterString(context, "currentPassword");
        String newPassword = this.getParameterExtractor().getParameterString(context, "newPassword");
        try {
            this.authenticationService.changePassword(userName, currentPassword, newPassword);
            Element retElem = new Element("message");
            retElem.setText("Senha alterada com sucesso");
            context.getBodyElement().addContent((Content)retElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CHANGE_PASSWORD_ERROR, e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

