/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.service.PrinterConfigService;
import br.com.sankhya.sps.enumeration.DocFlavorMetaData;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import br.com.sankhya.sps.http.validation.request.PrinterConfigurationValidator;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;

public class UpdatePrinterConfigCommand
extends AbstractCommand {
    private PrinterConfigService printerConfigService;
    private Validator validator;

    public UpdatePrinterConfigCommand(ParameterExtractor parameterExtractor, PrinterConfigService printerConfigService) {
        super(parameterExtractor);
        this.printerConfigService = printerConfigService;
        RequiredValidator requiredValidator = new RequiredValidator("printerName", this.getParameterExtractor());
        PrinterConfigurationValidator printerConfigurationValidator = new PrinterConfigurationValidator(parameterExtractor);
        this.validator = new CompositeValidator(requiredValidator, printerConfigurationValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        try {
            HashMap<DocTaste, String> docFlavorParams = new HashMap<DocTaste, String>();
            String paramName = null;
            String docFlavorParam = null;
            for (DocTaste docTaste : DocTaste.values()) {
                paramName = docTaste.toString();
                docFlavorParam = this.getParameterExtractor().getParameterString(context, paramName);
                if (docFlavorParam == null) continue;
                docFlavorParams.put(docTaste, docFlavorParam);
            }
            PrinterConfig printerConfig = null;
            DocTaste docTaste = null;
            DocFlavorMetaData docFlavorMetaData = null;
            for (Map.Entry entry : docFlavorParams.entrySet()) {
                docTaste = (DocTaste)entry.getKey();
                docFlavorMetaData = DocFlavorMetaData.valueOf((String)((String)entry.getValue()));
                printerConfig = this.printerConfigService.findByPrinterNameAndDocTaste(printerName, docTaste);
                printerConfig.setDocFlavorMetaData(docFlavorMetaData);
                this.printerConfigService.update(printerConfig);
            }
            Element printerConfigStatusElement = new Element("printerConfigStatus");
            printerConfigStatusElement.addContent("OK");
            context.getBodyElement().addContent((Content)printerConfigStatusElement);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

