/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.initializer.PrintersInitializer;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class RefreshPrintersCommand
extends AbstractCommand {
    private PrinterService printerService;
    private ConversionUtil conversionService;
    private PrintersInitializer printersInitializer;

    @Inject
    public RefreshPrintersCommand(ParameterExtractor parameterExtractor, PrinterService printerService, PrintersInitializer printersInitializer, ConversionUtil conversionService) {
        super(parameterExtractor);
        this.printerService = printerService;
        this.conversionService = conversionService;
        this.printersInitializer = printersInitializer;
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        try {
            this.printersInitializer.init();
            List<Printer> printers = this.printerService.findAllPrintersWithCompleteData();
            Element printersElem = new Element("impressoras");
            Element printerElem = null;
            for (Printer printer : printers) {
                printerElem = (Element)this.conversionService.convert((Object)printer, Element.class);
                printersElem.addContent((Content)printerElem);
            }
            context.getBodyElement().addContent((Content)printersElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_PRINTERS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

