/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.EnumValidator;
import com.sankhya.util.StringUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class ListPrintersCommand
extends AbstractCommand {
    private PrinterService printerService;
    private ConversionUtil conversionService;
    private Validator validator;

    @Inject
    public ListPrintersCommand(ParameterExtractor parameterExtractor, PrinterService printerService, ConversionUtil conversionService) {
        super(parameterExtractor);
        this.printerService = printerService;
        this.conversionService = conversionService;
        EnumValidator<DocTaste> mimeTypeValidator = new EnumValidator<DocTaste>(DocTaste.class, "mimeType", parameterExtractor);
        this.validator = new CompositeValidator(mimeTypeValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        String mimeType = this.getParameterExtractor().getParameterString(context, "mimeType");
        DocTaste docTaste = null;
        if (!StringUtils.isEmpty((String)mimeType)) {
            docTaste = DocTaste.valueOf((String)mimeType);
        }
        try {
            Element printersElem = new Element("impressoras");
            Element printerElem = null;
            List<Printer> printers = this.printerService.findPrintersByPrinterNameAndDocTaste(printerName, docTaste);
            for (Printer printer : printers) {
                printerElem = (Element)this.conversionService.convert((Object)printer, Element.class);
                printersElem.addContent((Content)printerElem);
            }
            context.getBodyElement().addContent((Content)printersElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_PRINTERS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

