/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.service.PrinterConfigService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.enumeration.DocFlavorMetaData;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class ListPrinterConfigCommand
extends AbstractCommand {
    private PrinterConfigService printerConfigService;
    private ConversionUtil conversionService;
    private Validator validator;

    public ListPrinterConfigCommand(ParameterExtractor parameterExtractor, ConversionUtil conversionService, PrinterConfigService printerConfigService) {
        super(parameterExtractor);
        this.conversionService = conversionService;
        this.printerConfigService = printerConfigService;
        RequiredValidator requiredValidator = new RequiredValidator("printerName", this.getParameterExtractor());
        this.validator = new CompositeValidator(requiredValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        try {
            Element printerConfigurationElement = new Element("printerConfiguration");
            Element configurationsElement = new Element("configurations");
            Element docFlavorsElement = new Element("docFlavors");
            printerConfigurationElement.addContent((Content)configurationsElement);
            printerConfigurationElement.addContent((Content)docFlavorsElement);
            Element printerConfigElem = null;
            Element metadataElem = null;
            DocFlavorMetaData[] metadataValues = DocFlavorMetaData.values();
            List<PrinterConfig> configs = this.printerConfigService.findByPrinterName(printerName);
            for (PrinterConfig printerConfig : configs) {
                printerConfigElem = (Element)this.conversionService.convert((Object)printerConfig, Element.class);
                configurationsElement.addContent((Content)printerConfigElem);
            }
            for (DocFlavorMetaData metadata : metadataValues) {
                metadataElem = (Element)this.conversionService.convert((Object)metadata, Element.class);
                docFlavorsElement.addContent((Content)metadataElem);
            }
            context.getBodyElement().addContent((Content)printerConfigurationElement);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_PRINTERS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

