/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import java.util.List;
import javax.inject.Singleton;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class ListCompletePrintersDataCommand
extends AbstractCommand {
    private PrinterService printerService;
    private ConversionUtil conversionService;

    public ListCompletePrintersDataCommand(ParameterExtractor parameterExtractor, PrinterService printerService, ConversionUtil conversionService) {
        super(parameterExtractor);
        this.printerService = printerService;
        this.conversionService = conversionService;
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        try {
            List<Printer> printers = this.printerService.findAllPrintersWithCompleteData();
            Element printersElem = new Element("impressoras");
            Element printerElem = null;
            for (Printer printer : printers) {
                printerElem = (Element)this.conversionService.convert((Object)printer, Element.class);
                printersElem.addContent((Content)printerElem);
            }
            context.getBodyElement().addContent((Content)printersElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_PRINTERS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

