/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.printer;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;

public class DeletePrintersCommand
extends AbstractCommand {
    private PrinterService printerService;
    private Validator validator;

    public DeletePrintersCommand(ParameterExtractor parameterExtractor, PrinterService printerService) {
        super(parameterExtractor);
        this.printerService = printerService;
        RequiredValidator requiredValidator = new RequiredValidator("printerName", this.getParameterExtractor());
        this.validator = new CompositeValidator(requiredValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult validationResult = this.validator.validate(context);
        if (!validationResult.isValid()) {
            throw new ValidationException(validationResult);
        }
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        try {
            Printer printer = this.printerService.findPrinterByPrinterName(printerName);
            this.printerService.deletePrintService(printer);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_DELETE_PRINTER, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

