/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.job;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.exception.BaseException;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.command.model.PrintReport;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.LongArrayValidator;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class ReprintJobsCommand
extends AbstractCommand {
    private static final Logger log = Logger.getLogger(ReprintJobsCommand.class);
    private JobService jobService;
    private ConversionUtil conversionService;
    private Validator validator;

    @Inject
    public ReprintJobsCommand(ParameterExtractor parameterExtractor, JobService jobService, ConversionUtil conversionService) {
        super(parameterExtractor);
        this.jobService = jobService;
        this.conversionService = conversionService;
        RequiredValidator requiredJobsIdsValidator = new RequiredValidator("jobsIds", this.getParameterExtractor(), "Ao menos um job deve ser selecionado.");
        LongArrayValidator longArrayValidator = new LongArrayValidator("jobsIds", this.getParameterExtractor(), "O formato da lista de jobs \u00e9 inv\u00e1lido.");
        this.validator = new CompositeValidator(requiredJobsIdsValidator, longArrayValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult result = this.validator.validate(context);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
        String jobsIdsParam = this.getParameterExtractor().getParameterString(context, "jobsIds");
        String[] jobsIds = jobsIdsParam.split(";");
        Long oldJobId = null;
        ArrayList<PrintReport> reports = new ArrayList<PrintReport>();
        PrintReport printReport = null;
        for (String id : jobsIds) {
            printReport = new PrintReport();
            reports.add(printReport);
            oldJobId = Long.parseLong(id);
            printReport.setOldJobId(oldJobId);
            try {
                Job oldJob = this.jobService.findJob(oldJobId);
                Job enqueuedJob = this.jobService.reprint(oldJob);
                printReport.setJobId(enqueuedJob.getId());
            }
            catch (BaseException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                printReport.setError(e);
            }
        }
        Element reportsElement = new Element("printReports");
        Element reportElement = null;
        for (PrintReport report : reports) {
            reportElement = (Element)this.conversionService.convert((Object)report, Element.class);
            reportsElement.addContent((Content)reportElement);
        }
        context.getBodyElement().addContent((Content)reportsElement);
    }
}

