/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.job;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.business.service.PrinterService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.enumeration.DocType;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.command.model.PrintReport;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.util.RequestUtil;
import com.sankhya.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import org.jdom.Content;
import org.jdom.Element;

public class PrintCommand
extends AbstractCommand {
    @Inject
    private JobService jobService;
    private PrinterService printerService;
    private ConversionUtil conversionUtil;
    private Validator validator;
    private RequestUtil requestUtil;

    public PrintCommand(ParameterExtractor parameterExtractor, PrinterService printerService, JobService jobService, ConversionUtil conversionUtil, Validator validator, RequestUtil requestUtil) {
        super(parameterExtractor);
        this.printerService = printerService;
        this.jobService = jobService;
        this.conversionUtil = conversionUtil;
        this.validator = validator;
        this.requestUtil = requestUtil;
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult result = this.validator.validate(context);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
        Job job = this.createJob(context);
        ServletInputStream inputStream = null;
        try {
            inputStream = context.getHttpRequest().getInputStream();
            Job enqueuedJob = this.jobService.print(job, (InputStream)inputStream);
            PrintReport printReport = new PrintReport();
            printReport.setJobId(enqueuedJob.getId());
            Element printReportElement = (Element)this.conversionUtil.convert((Object)printReport, Element.class);
            context.getBodyElement().addContent((Content)printReportElement);
        }
        catch (IOException e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_JOBS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw new CommandException(CommandErrorCode.COMMAND_ERROR, "Erro ao criar arquivo de impress\u00e3o " + e.getCause().getMessage());
            }
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Job createJob(RealRequestServiceContext context) {
        String originalFileExtension;
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        String jobDescription = this.getParameterExtractor().getParameterString(context, "jobDescription");
        String mimeType = this.getParameterExtractor().getParameterString(context, "mimeType");
        DocTaste docTasteValue = DocTaste.valueOf((String)mimeType);
        String userName = this.getParameterExtractor().getParameterString(context, "userName");
        String userId = this.getParameterExtractor().getParameterString(context, "userId");
        String copies = this.getParameterExtractor().getParameterString(context, "copies");
        int copiesNumber = Integer.parseInt(copies);
        String docType = this.getParameterExtractor().getParameterString(context, "docType");
        DocType docTypeValue = DocType.valueOf((String)docType);
        String originalFileName = this.getParameterExtractor().getParameterString(context, "fileName");
        if (StringUtils.isEmpty((String)originalFileName)) {
            originalFileName = docTypeValue.toString().toLowerCase();
        }
        if (StringUtils.isEmpty((String)(originalFileExtension = this.getParameterExtractor().getParameterString(context, "fileExtension")))) {
            originalFileExtension = docTasteValue.getDefaultFileExtension();
        }
        String clientIp = this.requestUtil.getClientAddr(context);
        Printer printer = this.printerService.findPrinterByPrinterName(printerName);
        Job job = Job.createJob(printer, jobDescription, copiesNumber, userId, userName, clientIp, docTasteValue, docTypeValue, originalFileName, originalFileExtension);
        printer.addJob(job);
        return job;
    }
}

