/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http.command.job;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.http.RealRequestServiceContext;
import br.com.sankhya.sps.http.command.AbstractCommand;
import br.com.sankhya.sps.http.command.exception.CommandErrorCode;
import br.com.sankhya.sps.http.command.exception.CommandException;
import br.com.sankhya.sps.http.extractor.ParameterExtractor;
import br.com.sankhya.sps.http.validation.CompositeValidator;
import br.com.sankhya.sps.http.validation.ValidationResult;
import br.com.sankhya.sps.http.validation.Validator;
import br.com.sankhya.sps.http.validation.exception.ValidationException;
import br.com.sankhya.sps.http.validation.param.RequiredValidator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jdom.Content;
import org.jdom.Element;

@Singleton
public class ListJobsByPrinterCommand
extends AbstractCommand {
    private JobService jobService;
    private ConversionUtil conversionService;
    private Validator validator;

    @Inject
    public ListJobsByPrinterCommand(ParameterExtractor parameterExtractor, JobService jobService, ConversionUtil conversionService) {
        super(parameterExtractor);
        this.jobService = jobService;
        this.conversionService = conversionService;
        RequiredValidator requiredValidator = new RequiredValidator("printerName", this.getParameterExtractor());
        this.validator = new CompositeValidator(requiredValidator);
    }

    @Override
    public void execute(RealRequestServiceContext context) throws CommandException {
        ValidationResult result = this.validator.validate(context);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
        String printerName = this.getParameterExtractor().getParameterString(context, "printerName");
        try {
            List<Job> jobs = this.jobService.findJobsByPrinterName(printerName);
            Element jobsElem = new Element("jobs");
            Element jobElem = null;
            for (Job job : jobs) {
                jobElem = (Element)this.conversionService.convert((Object)job, Element.class);
                jobsElem.addContent((Content)jobElem);
            }
            context.getBodyElement().addContent((Content)jobsElem);
        }
        catch (BusinessException e) {
            throw new CommandException(CommandErrorCode.CANNOT_RETRIEVE_JOBS, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new CommandException(CommandErrorCode.COMMAND_ERROR, e);
        }
    }
}

