/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http;

import br.com.sankhya.http.HttpFilesystem;
import br.com.sankhya.http.HttpListener;
import br.com.sankhya.sps.annotation.configuration.ConfigHttpServerPort;
import br.com.sankhya.sps.annotation.type.BrokerServer;
import br.com.sankhya.sps.annotation.type.WebServer;
import br.com.sankhya.sps.http.StoppableHttpServer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class WebConsole {
    public static final String WEB_CONSOLE_PORT_NAME = "web console port";
    public static final String LOGIN_SESSION_NAME = "login_sess";
    private StoppableHttpServer httpServer;
    private StoppableHttpServer printServer;
    private HttpListener fileSystem;
    private static Logger log = Logger.getLogger((String)WebConsole.class.getName());

    @Inject
    public WebConsole(@ConfigHttpServerPort int httpServerPort, @BrokerServer HttpListener serviceBrokerHttpListener, @WebServer HttpListener applicationListener) throws Exception {
        log.info((Object)"Iniciando webConsole...");
        this.httpServer = new StoppableHttpServer(httpServerPort);
        this.fileSystem = new HttpFilesystem("console");
        this.httpServer.addListener(".html", this.fileSystem);
        this.httpServer.addListener(".htm", this.fileSystem);
        this.httpServer.addListener(".swf", this.fileSystem);
        this.httpServer.addListener(".js", this.fileSystem);
        this.httpServer.addListener(".png", this.fileSystem);
        this.httpServer.addListener(".jpg", this.fileSystem);
        this.httpServer.addListener(".xml", this.fileSystem);
        this.httpServer.addListener(".sbr", serviceBrokerHttpListener);
        this.httpServer.addListener(".app", applicationListener);
    }

    public void init() {
        log.info((Object)"Iniciando threads do servidor http");
        Thread threadServer = new Thread((Runnable)((Object)this.httpServer), "WebConsole");
        threadServer.setDaemon(true);
        threadServer.start();
        log.info((Object)"HttpServer iniciado");
        log.info((Object)"Iniciando threads do PrintServer");
        Thread threadPrintServer = new Thread((Runnable)((Object)this.printServer), "PrintServer");
        threadPrintServer.setDaemon(true);
        threadPrintServer.start();
        log.info((Object)"PrintServer iniciado");
    }

    public void shutdown() {
        this.httpServer.stop();
    }
}

