/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.desktop;

import br.com.sankhya.desktop.dialog.AboutDialog;
import br.com.sankhya.desktop.dialog.WaitDialog;
import br.com.sankhya.sps.PrintServiceMain;
import br.com.sankhya.sps.annotation.configuration.ConfigAboutCopyright;
import br.com.sankhya.sps.annotation.configuration.ConfigAboutMessage;
import br.com.sankhya.sps.annotation.configuration.ConfigHttpServerPort;
import br.com.sankhya.sps.annotation.configuration.ConfigSpsVersion;
import br.com.sankhya.sps.profile.SPSConfigs;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JFrame;
import javax.swing.UIManager;

@Singleton
public class SystemTrayMenu {
    private static String ABOUT_TITLE = null;
    public static boolean isSankhyaProfile = SPSConfigs.getInstance().getProfile().isSankhyaProfile();
    private SystemTray systemTray;
    private TrayIcon trayIcon;
    private MenuItem aboutitem;
    private MenuItem sairItem;
    private MenuItem adminItem;
    @ConfigAboutCopyright
    @Inject
    private String aboutCopyrigth;
    @ConfigSpsVersion
    @Inject
    private String aboutVersion;
    @ConfigAboutMessage
    @Inject
    private String aboutMessage;
    @ConfigHttpServerPort
    @Inject
    private int httpServerPort;
    private WaitDialog waitDialog;
    private AboutDialog aboutDialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (SystemTray.isSupported()) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
            this.systemTray = SystemTray.getSystemTray();
            PopupMenu popupMenu = this.createPopupMenu();
            InputStream in = null;
            try {
                in = PrintServiceMain.class.getResourceAsStream("sps.ivb");
                if (in != null) {
                    Properties ivb = new Properties();
                    ivb.load(in);
                    this.aboutVersion = ivb.getProperty("sps.app.version") + "b" + ivb.getProperty("sps.app.build.number");
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.loadSystemTrayIcon(popupMenu);
        }
    }

    private PopupMenu createPopupMenu() {
        PopupMenu popupMenu = new PopupMenu();
        this.adminItem = new MenuItem("Administrar (WebConsole)");
        this.adminItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTrayMenu.this.adminItemActionPerformed();
            }
        });
        this.aboutitem = SPSConfigs.getInstance().getProfile().isSankhyaProfile() ? new MenuItem("Sobre o Sankhya Print Service") : new MenuItem("Sobre o Jiva Print Service");
        this.aboutitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTrayMenu.this.aboutItemActionPerformed();
            }
        });
        this.sairItem = new MenuItem("Sair");
        this.sairItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTrayMenu.this.exitItemActionPerformed();
            }
        });
        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            popupMenu.add(this.adminItem);
        }
        popupMenu.add(this.aboutitem);
        popupMenu.addSeparator();
        popupMenu.add(this.sairItem);
        return popupMenu;
    }

    private void loadSystemTrayIcon(PopupMenu popupMenu) throws AWTException {
        URL imageResource = null;
        if (isSankhyaProfile) {
            ABOUT_TITLE = "Sankhya Print Service";
            imageResource = SystemTrayMenu.class.getResource("/br/com/sankhya/sps/resources/print-service-16x16.png");
            Image imageAguardando = Toolkit.getDefaultToolkit().getImage(imageResource);
            this.trayIcon = new TrayIcon(imageAguardando, ABOUT_TITLE, popupMenu);
        } else {
            ABOUT_TITLE = "Jiva Print Service";
            imageResource = SystemTrayMenu.class.getResource("/br/com/sankhya/sps/resources/print-service-jiva16x16.png");
            Image imageAguardando = Toolkit.getDefaultToolkit().getImage(imageResource);
            this.trayIcon = new TrayIcon(imageAguardando, ABOUT_TITLE, popupMenu);
        }
        this.systemTray.add(this.trayIcon);
    }

    private void adminItemActionPerformed() {
        try {
            Desktop.getDesktop().browse(new URL("http://localhost:" + this.httpServerPort + "/index.html").toURI());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void aboutItemActionPerformed() {
        try {
            final String version = System.getProperty("java.version");
            InetAddress addr = InetAddress.getLocalHost();
            final String hostAddress = addr.getHostAddress();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringBuilder builder = new StringBuilder();
                    builder.append("<html>");
                    builder.append(SystemTrayMenu.this.aboutMessage);
                    builder.append("<ul>");
                    builder.append("<li>");
                    builder.append("Vers\u00e3o do Java: ");
                    builder.append(version);
                    builder.append("</li>");
                    builder.append("<li>");
                    builder.append("Host: ");
                    builder.append(hostAddress);
                    builder.append("</li>");
                    builder.append("<li>");
                    builder.append("Porta: ");
                    builder.append(SystemTrayMenu.this.httpServerPort);
                    builder.append("</li>");
                    builder.append("</ul>");
                    builder.append("</html>");
                    SystemTrayMenu.this.aboutDialog = new AboutDialog(ABOUT_TITLE.toString(), builder.toString(), SystemTrayMenu.this.aboutVersion, SystemTrayMenu.this.aboutCopyrigth);
                    SystemTrayMenu.this.aboutDialog.setSize(new Dimension(350, 270));
                    SystemTrayMenu.this.aboutDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            SystemTrayMenu.this.aboutDialog.dispose();
                        }
                    });
                    SystemTrayMenu.this.aboutDialog.setVisible(true);
                }
            });
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void exitItemActionPerformed() {
        Runnable shutdownRunnable = new Runnable(){

            @Override
            public void run() {
                PrintServiceMain.getInstance().shutdown();
                System.exit(0);
            }
        };
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        threadPool.execute(shutdownRunnable);
        this.waitDialog = new WaitDialog((Frame)new JFrame(), true);
        this.waitDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.waitDialog.setVisible(true);
    }

    public void shutdown() {
        if (this.waitDialog != null) {
            this.waitDialog.dispose();
        }
        if (this.aboutDialog != null) {
            this.aboutDialog.dispose();
        }
        this.systemTray.remove(this.trayIcon);
    }
}

