/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.concurrent;

import br.com.sankhya.sps.concurrent.tasks.FixedDelayTask;
import br.com.sankhya.sps.util.Preconditions;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class ScheduledTasksManager {
    private static final Logger log = Logger.getLogger(ScheduledTasksManager.class);
    private final ScheduledExecutorService scheduler;
    private List<FixedDelayTask> fixedDelayTasks;

    @Inject
    public ScheduledTasksManager(List<FixedDelayTask> fixedDelayTasks) {
        Preconditions.checkNotNull(fixedDelayTasks, (String)"A lista de tarefas n\u00e3o pode ser nula");
        Preconditions.checkArgument((fixedDelayTasks.size() > 0 ? 1 : 0) != 0, (String)"A lista de tarefas deve ter ao menos um elemento");
        this.scheduler = Executors.newScheduledThreadPool(fixedDelayTasks.size());
        this.fixedDelayTasks = fixedDelayTasks;
    }

    public void init() {
        for (FixedDelayTask task : this.fixedDelayTasks) {
            this.scheduler.scheduleWithFixedDelay(task, task.getInitialDelay(), task.getDelay(), task.getTimeUnit());
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(60);
    }

    public void shutdown(int seconds) throws InterruptedException {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(seconds, TimeUnit.SECONDS)) {
            this.scheduler.shutdownNow();
            if (!this.scheduler.awaitTermination(seconds, TimeUnit.SECONDS)) {
                log.error((Object)"Pool did not terminate");
            }
        }
    }
}

