/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.concurrent;

import br.com.sankhya.sps.annotation.configuration.ConfigJobTimeout;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.concurrent.JobConsumer;
import br.com.sankhya.sps.util.PrintServiceUtil;
import br.com.sankhya.sps.util.print.DocumentPrinterUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.print.PrintService;
import org.apache.log4j.Logger;

@Singleton
public class PrinterQueueManager {
    private static final int POOL_MIN_SIZE = 1;
    private static final Logger log = Logger.getLogger(PrinterQueueManager.class);
    @Inject
    @ConfigJobTimeout
    private int jobTimeout;
    @Inject
    private DocumentPrinterUtil documentPrinterUtil;
    @Inject
    private JobService jobService;
    @Inject
    private PrintServiceUtil printServiceUtil;
    private Map<String, BlockingQueue<Job>> queues;
    private Map<String, JobConsumer> consumers;
    private ExecutorService executorService;

    public void putJob(Job job) throws InterruptedException {
        String printerName = job.getPrinter().getPrinterName();
        BlockingQueue<Job> queue = this.queues.get(printerName);
        queue.put(job);
    }

    public void init() {
        PrintService[] printServices;
        this.queues = new HashMap<String, BlockingQueue<Job>>();
        this.consumers = new HashMap<String, JobConsumer>();
        LinkedBlockingQueue<Job> queue = null;
        JobConsumer consumer = null;
        for (PrintService printService : printServices = this.printServiceUtil.getPrintServices()) {
            queue = new LinkedBlockingQueue<Job>();
            String name = "Consumidor: " + printService.getName();
            consumer = new JobConsumer(name, queue, this, this.documentPrinterUtil, this.jobService, this.jobTimeout);
            this.consumers.put(printService.getName(), consumer);
            this.queues.put(printService.getName(), queue);
        }
        this.executorService = Executors.newFixedThreadPool(Math.max(this.consumers.size(), 1));
        for (Map.Entry<String, JobConsumer> entry : this.consumers.entrySet()) {
            this.executorService.execute(entry.getValue());
        }
    }

    public void shutdown(int seconds) throws InterruptedException {
        this.executorService.shutdown();
        if (!this.executorService.awaitTermination(seconds, TimeUnit.SECONDS)) {
            this.executorService.shutdownNow();
            if (!this.executorService.awaitTermination(seconds, TimeUnit.SECONDS)) {
                log.error((Object)"Pool did not terminate");
            }
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(60);
    }
}

