/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.concurrent;

import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.concurrent.PrinterQueueManager;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.print.DocumentPrinterUtil;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class JobConsumer
implements Runnable {
    private static final Logger log = Logger.getLogger(JobConsumer.class);
    private BlockingQueue<Job> queue;
    private DocumentPrinterUtil documentPrinterUtil;
    private String name;
    private JobService jobService;
    private PrinterQueueManager printerQueueManager;
    private int jobTimeout;
    private boolean executeForever = true;

    public JobConsumer(String name, BlockingQueue<Job> queue, PrinterQueueManager printerQueueManager, DocumentPrinterUtil documentPrinterUtil, JobService jobService, int jobTimeout, boolean executeForever) {
        this.name = name;
        this.queue = queue;
        this.printerQueueManager = printerQueueManager;
        this.documentPrinterUtil = documentPrinterUtil;
        this.jobService = jobService;
        this.jobTimeout = jobTimeout;
        this.executeForever = executeForever;
    }

    public JobConsumer(String name, BlockingQueue<Job> queue, PrinterQueueManager printerQueueManager, DocumentPrinterUtil documentPrinterUtil, JobService jobService, int jobTimeout) {
        this(name, queue, printerQueueManager, documentPrinterUtil, jobService, jobTimeout, true);
    }

    @Override
    public void run() {
        do {
            try {
                this.print();
            }
            catch (InterruptedException e) {
                log.warn((Object)"Consumidor parou.");
                log.debug((Object)e);
            }
            catch (BusinessException e) {
                log.error((Object)"N\u00e3o foi poss\u00edvel atualizar o status do Job.", (Throwable)((Object)e));
            }
        } while (this.executeForever);
    }

    private void handleException(Job job, Exception e, JobStatus jobStatus, String jobStatusMessage) {
        this.jobService.updateJobStatus(job, jobStatus, jobStatusMessage);
        log.warn((Object)jobStatusMessage, (Throwable)e);
    }

    public void print() throws InterruptedException {
        log.debug((Object)this.name);
        Job job = this.queue.take();
        log.info((Object)("Imprimindo job: " + job.getDescription()));
        this.jobService.updateJobStatus(job, JobStatus.SENDING, "Imprimindo");
        try {
            log.debug((Object)"Inicando impress\u00e3o");
            this.documentPrinterUtil.print(job);
            log.debug((Object)"Impress\u00e3o terminada");
        }
        catch (PrintException e) {
            boolean canRequeue;
            boolean bl = canRequeue = !job.isTimeoutToErrorExpired(this.jobTimeout) && e.getErrorCode().equals(PrintErrorCode.PRINTER_ERROR);
            if (canRequeue) {
                this.handleException(job, (Exception)((Object)e), JobStatus.WAITING, "Aguardando impressora. Recolocando Job na fila.");
                this.printerQueueManager.putJob(job);
            } else {
                this.handleException(job, (Exception)((Object)e), JobStatus.ERROR, "Ocorreu um erro durante a impress\u00e3o: " + e.getMessage());
            }
        }
        catch (RuntimeException e) {
            this.handleException(job, e, JobStatus.ERROR, "Ocorreu um erro durante a impress\u00e3o: " + e.getMessage());
        }
    }
}

