/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.service;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.repository.JobRepository;
import br.com.sankhya.sps.business.repository.PrinterConfigRepository;
import br.com.sankhya.sps.business.repository.PrinterRepository;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.util.PrintServiceUtil;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.print.PrintService;

@Singleton
public class PrinterService {
    private PrinterRepository printerRepository;
    private PrinterConfigRepository printerConfigRepository;
    private JobRepository jobRepository;
    private PrintServiceUtil printServiceUtil;

    @Inject
    public PrinterService(PrinterRepository printerRepository, PrintServiceUtil printServiceUtil, PrinterConfigRepository printerConfigRepository, JobRepository jobRepository) {
        this.printerRepository = printerRepository;
        this.printServiceUtil = printServiceUtil;
        this.printerConfigRepository = printerConfigRepository;
        this.jobRepository = jobRepository;
    }

    public List<Printer> findAllPrintersWithCompleteData() {
        return this.printerRepository.findAllComplete();
    }

    public Printer findPrinterByPrinterName(String printerName) {
        Printer printer = this.printerRepository.findByPrinterName(printerName);
        return printer;
    }

    public void loadPrintService(Printer printer) {
        PrintService printService = this.printServiceUtil.getPrintService(printer.getPrinterName());
        printer.setPrintService(printService);
    }

    public void loadPrintService(List<Printer> printers) {
        for (Printer printer : printers) {
            this.loadPrintService(printer);
        }
    }

    public List<Printer> findPrintersByPrinterNameAndDocTaste(String printerName, DocTaste docTaste) {
        List<Printer> printers = this.printerRepository.findPrintersByPrinterNameAndDocTaste(printerName, docTaste);
        return printers;
    }

    public void deletePrintService(Printer printer) {
        List<PrinterConfig> listPrinterConfigs = this.printerConfigRepository.findByPrinterName(printer.getPrinterName());
        for (PrinterConfig printerConfig : listPrinterConfigs) {
            this.printerConfigRepository.delete(printerConfig.getId());
        }
        List<Job> listJobs = this.jobRepository.findByPrinterName(printer.getPrinterName());
        for (Job job : listJobs) {
            this.jobRepository.delete(job.getId());
        }
        this.printerRepository.delete(printer.getId());
    }
}

