/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.service;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.repository.JobRepository;
import br.com.sankhya.sps.business.repository.PrinterRepository;
import br.com.sankhya.sps.concurrent.PrinterQueueManager;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import br.com.sankhya.sps.util.JobUtil;
import br.com.sankhya.sps.util.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class JobService {
    private static final Logger log = Logger.getLogger(JobService.class);
    private static final int JOB_COLLECTOR_DELAY = 600000;
    private static boolean jobCollectorStarted = false;
    private JobRepository jobRepository;
    private PrinterRepository printerRepository;
    private PrinterQueueManager printerQueueManager;
    private JobUtil jobUtil;

    @Inject
    public JobService(JobRepository jobRepository, PrinterRepository printerRepository, PrinterQueueManager printerQueueManager, JobUtil jobUtil) {
        this.jobRepository = jobRepository;
        this.printerRepository = printerRepository;
        this.printerQueueManager = printerQueueManager;
        this.jobUtil = jobUtil;
    }

    public Job createJob(Job job) {
        try {
            Job createdJob = this.jobRepository.create(job);
            this.printerRepository.update(createdJob.getPrinter());
            return createdJob;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (RuntimeException e) {
            log.debug((Object)e, (Throwable)e);
            throw new BusinessException(BusinessErrorCode.CANNOT_SAVE, e);
        }
    }

    public Job updateJob(Job job) {
        try {
            Job updatedJob = this.jobRepository.update(job);
            return updatedJob;
        }
        catch (RuntimeException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_SAVE, e);
        }
    }

    public Job updateJobStatus(Job job, JobStatus jobStatus, String jobStatusMessage) {
        try {
            Preconditions.checkNotNull((Object)job, (String)"O job n\u00e3o pode ser nulo");
            Preconditions.checkNotNull((Object)jobStatus, (String)"O status do job n\u00e3o pode ser nulo");
            Preconditions.checkNotNull((Object)jobStatusMessage, (String)"A mensagem do status do job n\u00e3o pode ser nula");
            job.setJobStatus(jobStatus);
            job.setJobStatusMessage(jobStatusMessage);
            Job updatedJob = this.jobRepository.update(job);
            return updatedJob;
        }
        catch (RuntimeException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_SAVE, e);
        }
    }

    public Job findJob(Long jobId) {
        Job job = (Job)this.jobRepository.find(jobId);
        return job;
    }

    public List<Job> findJobsByPrinterName(String printerName) {
        List<Job> jobs = this.jobRepository.findByPrinterName(printerName);
        return jobs;
    }

    public List<Job> findByPrinterNameOrJobStatusOrUserIdOrJobId(String printerName, JobStatus jobStatus, String userId, Long jobId) {
        List<Job> jobs = this.jobRepository.findByPrinterNameOrJobStatusOrUserIdOrJobId(printerName, jobStatus, userId, jobId);
        return jobs;
    }

    public Job reprint(Job oldJob) {
        try {
            if (oldJob.isLifeTimeExpired()) {
                throw new PrintException(PrintErrorCode.EXPIRED_JOB);
            }
            if (!oldJob.statusAllowReprint()) {
                throw new PrintException(PrintErrorCode.STATUS_NOT_ALLOWED_TO_REPRINT);
            }
            if (!this.jobUtil.jobFileExists(oldJob)) {
                throw new PrintException(PrintErrorCode.FILE_NOT_FOUND);
            }
            Job newJob = oldJob.cloneJob();
            InputStream inputStream = this.jobUtil.getOldFileStream(oldJob);
            return this.print(newJob, inputStream);
        }
        catch (FileNotFoundException e) {
            throw new PrintException(PrintErrorCode.FILE_NOT_FOUND, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR, (Throwable)e);
        }
    }

    public Job print(Job job, InputStream inputStream) {
        try {
            this.jobUtil.createJobFile(job, inputStream);
            Job createdJob = this.createJob(job);
            this.printerQueueManager.putJob(createdJob);
            return createdJob;
        }
        catch (InterruptedException e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR, "Fila de jobs est\u00e1 parada. Entre em contato com o administrador.", (Throwable)e);
        }
        catch (IOException e) {
            throw new PrintException(PrintErrorCode.PRINT_ERROR, "N\u00e3o foi poss\u00edvel criar o arquivo do job.", (Throwable)e);
        }
    }

    public void removeExpiredJobs() {
        try {
            List<Job> expiredJobs = this.jobRepository.findExpiredJobs();
            for (Job job : expiredJobs) {
                if (this.jobUtil.jobFileExists(job)) {
                    this.jobUtil.deleteJobFile(job);
                }
                this.jobRepository.delete(job.getId());
            }
        }
        catch (IOException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_DELETE, "Job n\u00e3o pode ser deletado pois arquivo n\u00e3o pode ser deletado");
        }
    }

    public void checkUnknownJobs() {
        List<Job> undeterminedJobs = this.jobRepository.findJobsWithUndeterminedStatus();
        for (Job job : undeterminedJobs) {
            job.setJobStatus(JobStatus.UNKNOWN);
            job.setJobStatusMessage("O sistema foi interrompido e n\u00e3o foi poss\u00edvel determinar o status do Job");
        }
        this.jobRepository.update(undeterminedJobs);
    }

    public void startJobCollector() {
        if (jobCollectorStarted) {
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JobService.this.jobRepository.removeDisposeJobs();
            }
        }, new Date(), 600000L);
        jobCollectorStarted = true;
    }
}

