/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.service;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.ApiKey;
import br.com.sankhya.sps.business.model.User;
import br.com.sankhya.sps.business.repository.ApiKeyRepository;
import br.com.sankhya.sps.business.repository.UserRepository;
import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.crypto.exception.CryptoException;
import com.sankhya.util.StringUtils;
import javax.persistence.NoResultException;
import org.apache.log4j.Logger;

public class AuthenticationService {
    private static final Logger log = Logger.getLogger(AuthenticationService.class);
    private UserRepository userRepository;
    private Encryptor passwordEncryptor;
    private Encryptor hmacEncryptor;
    private ApiKeyRepository apiKeyRepository;

    public AuthenticationService(UserRepository userRepository, Encryptor passwordEncryptor, Encryptor hmacEncryptor, ApiKeyRepository apiKeyRepository) {
        this.userRepository = userRepository;
        this.passwordEncryptor = passwordEncryptor;
        this.hmacEncryptor = hmacEncryptor;
        this.apiKeyRepository = apiKeyRepository;
    }

    public boolean isValidUser(String userName, String password) throws BusinessException {
        if (userName == null || password == null) {
            return false;
        }
        try {
            User user = this.userRepository.findUserbyUsername(userName);
            boolean validPassword = this.isValidPassword(user, password);
            return validPassword;
        }
        catch (NoResultException e) {
            return false;
        }
        catch (CryptoException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_ENCRYPT_PASSWORD, e);
        }
    }

    public void changePassword(String userName, String currentPassword, String newPassword) throws BusinessException {
        try {
            User user = this.userRepository.findUserbyUsername(userName);
            boolean validPassword = this.isValidPassword(user, currentPassword);
            if (!validPassword) {
                throw new BusinessException(BusinessErrorCode.INCORRECT_PASSWORD);
            }
            String encryptedNewPassword = this.passwordEncryptor.encrypt(newPassword);
            user.setPassword(encryptedNewPassword);
            this.userRepository.update(user);
        }
        catch (NoResultException e) {
            throw new BusinessException(BusinessErrorCode.RESULT_NOT_FOUND, e);
        }
        catch (CryptoException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_ENCRYPT_PASSWORD, e);
        }
    }

    private boolean isValidPassword(User user, String password) throws CryptoException {
        String encryptedCurrentPassword = this.passwordEncryptor.encrypt(password);
        return StringUtils.safelyEquals((Object)user.getPassword(), (Object)encryptedCurrentPassword);
    }

    public ApiKey getLastApiKey() {
        ApiKey apiKey = this.apiKeyRepository.findLastApiKey();
        return apiKey;
    }

    public ApiKey findValidApikey(String apiKeyValue) {
        ApiKey apiKey = this.apiKeyRepository.findValidByValue(apiKeyValue);
        return apiKey;
    }

    public boolean isValidHmac(String uri, ApiKey apikey, String clientHmac) {
        try {
            String toEncrypt = uri + apikey.getValue();
            log.debug((Object)("Base do HMAC no servidor: " + toEncrypt));
            String serverHmac = this.hmacEncryptor.encrypt(toEncrypt);
            return serverHmac.equals(clientHmac);
        }
        catch (CryptoException e) {
            throw new BusinessException(BusinessErrorCode.CANNOT_ENCRYPT, e);
        }
    }

    public void renewApiKeys() {
        log.debug((Object)"Deletando ApiKeys antigas");
        this.apiKeyRepository.deleteExpiredApiKeys();
        if (this.apiKeyRepository.count() < 5L) {
            log.debug((Object)"Criando uma nova ApiKey");
            ApiKey apiKey = ApiKey.newInstance();
            this.apiKeyRepository.create(apiKey);
            log.debug((Object)"ApiKey criada");
        }
    }
}

