/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.model.User;
import br.com.sankhya.sps.business.repository.AbstractRepository;
import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.crypto.exception.CryptoException;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Singleton
public class UserRepository
extends AbstractRepository<User> {
    private static final long ADMIN_DEFAULT_ID = 1L;
    private static final String ADMIN_DEFAULT_PASSWORD = "tecsis";
    private static final String ADMIN_DEFAULT_USERNAME = "admin";
    private static final Logger log = Logger.getLogger(UserRepository.class);
    private Encryptor encryptor;

    public UserRepository(EntityManagerFactory entityManagerFactory, Encryptor encryptor) {
        super(entityManagerFactory);
        this.encryptor = encryptor;
    }

    public User findUserbyUsername(String username) {
        try (EntityManager em = this.getEntityManager();){
            User user;
            Query query = em.createQuery("select u from User u where u.username = :username");
            query.setParameter("username", (Object)username);
            User user2 = user = (User)query.getSingleResult();
            return user2;
        }
    }

    public void initAdminUser() throws CryptoException {
        try {
            this.findUserbyUsername(ADMIN_DEFAULT_USERNAME);
            log.info((Object)"Usu\u00e1rio administrador j\u00e1 existe");
        }
        catch (NoResultException e) {
            log.info((Object)"Usu\u00e1rio administrador n\u00e3o existe. Criando usu\u00e1rio padr\u00e3o.");
            User admin = new User();
            admin.setId(1L);
            admin.setUsername(ADMIN_DEFAULT_USERNAME);
            String encryptedPassword = this.encryptor.encrypt(ADMIN_DEFAULT_PASSWORD);
            admin.setPassword(encryptedPassword);
            this.create(admin);
            log.info((Object)"Usu\u00e1rio administrador criado. Login: admin | Senha: tecsis");
        }
    }
}

