/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.business.repository.AbstractRepository;
import br.com.sankhya.sps.enumeration.DocTaste;
import java.util.List;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.log4j.Logger;

@Singleton
public class PrinterRepository
extends AbstractRepository<Printer> {
    private static final Logger log = Logger.getLogger(PrinterRepository.class);

    public PrinterRepository(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public List<Printer> findAllComplete() {
        try (EntityManager em = this.getEntityManager();){
            Query query = em.createQuery("SELECT p FROM Printer p ");
            List items = query.getResultList();
            for (Printer printer : items) {
                printer.getJobs().size();
            }
            List list = items;
            return list;
        }
    }

    public Printer findByPrinterName(String printerName) {
        try (EntityManager em = this.getEntityManager();){
            Printer printer;
            Query query = em.createQuery("SELECT p FROM Printer p where UPPER(p.printerName) = UPPER(:name)");
            query.setParameter("name", (Object)printerName);
            Printer printer2 = printer = (Printer)query.getSingleResult();
            return printer2;
        }
    }

    public List<Printer> findPrintersByPrinterNameAndDocTaste(String printerName, DocTaste docTaste) {
        try (EntityManager em = this.getEntityManager();){
            List results;
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Printer.class);
            Root root = query.from(Printer.class);
            root.fetch("jobs", JoinType.LEFT);
            ListAttribute jobsAttribute = root.getModel().getList("jobs", Job.class);
            root.fetch((PluralAttribute)jobsAttribute, JoinType.LEFT);
            query.select((Selection)root).distinct(true);
            Predicate predicate = builder.and(new Predicate[0]);
            if (printerName != null) {
                predicate = builder.and(new Predicate[]{builder.equal((Expression)root.get("printerName"), (Object)printerName)});
            }
            if (docTaste != null) {
                Path docTastes = root.get("supportedDocTastes");
                predicate = builder.and((Expression)predicate, (Expression)builder.isMember((Object)docTaste, (Expression)docTastes));
            }
            TypedQuery typedQuery = em.createQuery(query.where((Expression)predicate));
            typedQuery.setHint("eclipselink.refresh", (Object)"True");
            List list = results = typedQuery.getResultList();
            return list;
        }
    }
}

