/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.PrinterConfig;
import br.com.sankhya.sps.business.repository.AbstractRepository;
import br.com.sankhya.sps.enumeration.DocTaste;
import java.util.List;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;

@Singleton
public class PrinterConfigRepository
extends AbstractRepository<PrinterConfig> {
    public PrinterConfigRepository(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    public PrinterConfig create(PrinterConfig printerConfig) {
        DocTaste docTaste = printerConfig.getDocTaste();
        String printerName = printerConfig.getPrinter().getPrinterName();
        PrinterConfig existentPrinterConfig = this.findByPrinterNameAndDocTaste(printerName, docTaste);
        if (existentPrinterConfig != null) {
            throw new BusinessException(BusinessErrorCode.CANNOT_SAVE_PREEXISTENT_RECORD);
        }
        return super.create(printerConfig);
    }

    public PrinterConfig findByPrinterNameAndDocTaste(String printerName, DocTaste docTaste) {
        try (EntityManager em = this.getEntityManager();){
            PrinterConfig printerConfig;
            Query query = em.createQuery("select pc from PrinterConfig pc where pc.docTaste = :docTaste AND pc.printer.printerName = :printerName");
            query.setParameter("printerName", (Object)printerName);
            query.setParameter("docTaste", (Object)docTaste);
            PrinterConfig printerConfig2 = printerConfig = (PrinterConfig)query.getSingleResult();
            return printerConfig2;
        }
    }

    public List<PrinterConfig> findByPrinterName(String printerName) {
        try (EntityManager em = this.getEntityManager();){
            List printerConfigs;
            Query query = em.createQuery("select pc from PrinterConfig pc where pc.printer.printerName = :printerName");
            query.setParameter("printerName", (Object)printerName);
            List list = printerConfigs = query.getResultList();
            return list;
        }
    }
}

