/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.exception.BusinessValidationException;
import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.business.repository.AbstractRepository;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.util.JobUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.ConstraintViolationException;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

@Singleton
public class JobRepository
extends AbstractRepository<Job> {
    private Logger log = Logger.getLogger(JobRepository.class);

    public JobRepository(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    public Job create(Job job) {
        Date now = new Date();
        job.setCreatedDate(now);
        job.setUpdatedDate(now);
        return super.create(job);
    }

    @Override
    public Job update(Job job) {
        Date now = new Date();
        job.setUpdatedDate(now);
        return super.update(job);
    }

    public List<Job> findByPrinterName(String printerName) {
        try (EntityManager em = this.getEntityManager();){
            List items;
            Query query = em.createQuery("SELECT j FROM Job j WHERE j.printer.printerName=:printerName");
            query.setParameter("printerName", (Object)printerName);
            List list = items = query.getResultList();
            return list;
        }
    }

    public List<Job> findByPrinterNameOrJobStatusOrUserIdOrJobId(String printerName, JobStatus jobStatus, String userId, Long jobId) {
        try (EntityManager em = this.getEntityManager();){
            List results;
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Job.class);
            Root from = query.from(Job.class);
            query.select((Selection)from);
            Predicate predicate = builder.and(new Predicate[]{builder.equal((Expression)from.join("printer").get("printerName"), (Object)printerName)});
            query.where(new Predicate[0]);
            if (jobStatus != null) {
                predicate = builder.and((Expression)predicate, (Expression)builder.equal((Expression)from.get("jobStatus"), (Object)jobStatus));
            }
            if (userId != null) {
                predicate = builder.and((Expression)predicate, (Expression)builder.equal((Expression)from.get("userId"), (Object)userId));
            }
            if (jobId != null) {
                predicate = builder.and((Expression)predicate, (Expression)builder.equal((Expression)from.get("id"), (Object)jobId));
            }
            TypedQuery typedQuery = em.createQuery(query.where((Expression)predicate));
            typedQuery.setHint("eclipselink.refresh", (Object)"True");
            List list = results = typedQuery.getResultList();
            return list;
        }
    }

    public List<Job> findExpiredJobs() {
        try (EntityManager em = this.getEntityManager();){
            List jobList;
            DateTime dt = new DateTime();
            Date limit = dt.minusHours(24).toDate();
            Query query = em.createQuery("SELECT j FROM Job j WHERE j.createdDate < :limit");
            query.setParameter("limit", limit, TemporalType.TIMESTAMP);
            List list = jobList = query.getResultList();
            return list;
        }
    }

    public List<Job> findJobsWithUndeterminedStatus() {
        try (EntityManager em = this.getEntityManager();){
            List jobList;
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Job.class);
            Root from = query.from(Job.class);
            Predicate wherePredicate = from.get("jobStatus").in(new Object[]{JobStatus.PRINTING, JobStatus.READY, JobStatus.SENDING, JobStatus.REQUIRE_ATTENTION, JobStatus.WAITING});
            query.select((Selection)from).where((Expression)wherePredicate);
            TypedQuery typedQuery = em.createQuery(query);
            typedQuery.setHint("eclipselink.refresh", (Object)"True");
            List list = jobList = typedQuery.getResultList();
            return list;
        }
    }

    public List<Job> findUnknowJobs() {
        try (EntityManager em = this.getEntityManager();){
            List jobList;
            Query query = em.createQuery("SELECT j FROM Job j WHERE j.jobStatus = :jobStatus");
            query.setParameter("jobStatus", (Object)JobStatus.UNKNOWN);
            query.setHint("eclipselink.refresh", (Object)"True");
            List list = jobList = query.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposeJobs() {
        this.log.info((Object)"Buscando por Jobs descart\u00e1veis...");
        EntityManager em = this.getEntityManager();
        em.getTransaction().begin();
        Connection conn = (Connection)em.unwrap(Connection.class);
        try {
            String statusToDiscardInMinutes = JobUtil.getJobsToDisposeInMinutes();
            String statusToDiscardInADay = JobUtil.getJobsToDisposeInOneDay();
            PreparedStatement stm = conn.prepareStatement("SELECT ID FROM Job j WHERE (j.jobStatus IN (" + statusToDiscardInMinutes + ") AND (TIMESTAMPDIFF(SQL_TSI_MINUTE, j.updatedDate, CURRENT_TIMESTAMP))>=30) OR (j.jobStatus IN (" + statusToDiscardInADay + ") AND (TIMESTAMPDIFF(SQL_TSI_HOUR, j.updatedDate, CURRENT_TIMESTAMP))>=24)");
            ResultSet rs = stm.executeQuery();
            int jobsRemoved = 0;
            while (rs.next()) {
                this.delete(rs.getLong("ID"));
                ++jobsRemoved;
            }
            this.log.info((Object)(jobsRemoved + " Jobs descartados com sucesso!"));
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                em.getTransaction().commit();
                conn.close();
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    @Override
    public List<Job> update(List<Job> undeterminedJobs) {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        ArrayList<Job> updatedJobs = new ArrayList<Job>();
        Job updatedJob = null;
        Date now = new Date();
        try {
            tx.begin();
            for (Job job : undeterminedJobs) {
                job.setUpdatedDate(now);
                updatedJob = (Job)em.merge((Object)job);
                updatedJobs.add(updatedJob);
            }
            em.flush();
            tx.commit();
            ArrayList<Job> i$ = updatedJobs;
            return i$;
        }
        catch (ConstraintViolationException e) {
            tx.rollback();
            throw new BusinessValidationException(e.getConstraintViolations(), BusinessErrorCode.CANNOT_SAVE, (Throwable)e);
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw new BusinessException(BusinessErrorCode.CANNOT_UPDATE, e);
        }
        finally {
            em.close();
        }
    }
}

