/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.model.ApiKey;
import br.com.sankhya.sps.business.repository.AbstractRepository;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.joda.time.DateTime;

public class ApiKeyRepository
extends AbstractRepository<ApiKey> {
    public ApiKeyRepository(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public ApiKey findValidByValue(String value) {
        try (EntityManager em = this.getEntityManager();){
            ApiKey apiKey;
            DateTime dt = new DateTime();
            Date limit = dt.minusMinutes(5).toDate();
            Query query = em.createQuery("SELECT a FROM ApiKey a WHERE a.value=:value and a.createdDate >= :limit");
            query.setParameter("value", (Object)value);
            query.setParameter("limit", limit, TemporalType.TIMESTAMP);
            ApiKey apiKey2 = apiKey = (ApiKey)query.getSingleResult();
            return apiKey2;
        }
    }

    public void deleteExpiredApiKeys() {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            DateTime dt = new DateTime();
            Date limit = dt.minusMinutes(5).toDate();
            Query query = em.createQuery("SELECT a FROM ApiKey a WHERE a.createdDate < :limit");
            query.setParameter("limit", limit, TemporalType.TIMESTAMP);
            List apiKeyList = query.getResultList();
            for (ApiKey apiKey : apiKeyList) {
                this.delete(apiKey.getId());
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw new BusinessException(BusinessErrorCode.CANNOT_UPDATE, e);
        }
        finally {
            em.close();
        }
    }

    public ApiKey findLastApiKey() {
        try (EntityManager em = this.getEntityManager();){
            DateTime dt = new DateTime();
            Date limit = dt.minusMinutes(5).toDate();
            Query query = em.createQuery("SELECT a FROM ApiKey a WHERE a.createdDate >= :limit ORDER BY a.id DESC");
            query.setMaxResults(1);
            query.setParameter("limit", limit, TemporalType.TIMESTAMP);
            List apiKeys = query.getResultList();
            if (apiKeys == null || apiKeys.isEmpty()) {
                ApiKey createdApiKey;
                ApiKey apiKey = ApiKey.newInstance();
                ApiKey apiKey2 = createdApiKey = this.create(apiKey);
                return apiKey2;
            }
            ApiKey apiKey = (ApiKey)apiKeys.get(0);
            return apiKey;
        }
    }
}

